/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.benchmarks;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
public class NanoTimerBench {
    private long last;

    @Benchmark
    public long latency() {
        return System.nanoTime();
    }

    @Benchmark
    public long granularity() {
        long cur;
        long lst = this.last;
        while ((cur = System.nanoTime()) == lst) {
        }
        this.last = cur;
        return cur;
    }
}

