/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.ValueConversionException;
import org.openjdk.jmh.runner.CompilerHints;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.OptionFormatter;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.util.Version;
import org.openjdk.jmh.validation.tests.BlackholeConsecutiveTest;
import org.openjdk.jmh.validation.tests.BlackholeConsumeCPUTest;
import org.openjdk.jmh.validation.tests.BlackholePipelinedTest;
import org.openjdk.jmh.validation.tests.BlackholeSingleTest;
import org.openjdk.jmh.validation.tests.CompilerHintsTest;
import org.openjdk.jmh.validation.tests.HelperMethodsTest;
import org.openjdk.jmh.validation.tests.ScoreStabilityTest;
import org.openjdk.jmh.validation.tests.ThermalRundownTest;
import org.openjdk.jmh.validation.tests.ThreadScalingTest;
import org.openjdk.jmh.validation.tests.TimingMeasurementsTest;

public class Main {
    public static void main(String[] args) throws RunnerException, CommandLineOptionException, IOException {
        Mode mode;
        List tests;
        PrintWriter pw = new PrintWriter(System.out, true);
        pw.println("JMH Core Benchmarks, Validation Tests");
        pw.println("----------------------------------------------------------------------------------------------------------");
        pw.println();
        pw.println("# " + Version.getVersion());
        pw.println("# " + Utils.getCurrentJvmVersion());
        pw.println("# " + Utils.getCurrentOSVersion());
        pw.println();
        Utils.reflow((PrintWriter)pw, (String)"These tests assess the current benchmarking environment health, including hardware, OS, JVM, and JMH itself. While the failure on these tests does not immediately means the problem with environment, it is instructive to understand and follow up on oddities in these tests.", (int)80, (int)2);
        pw.println();
        Utils.reflow((PrintWriter)pw, (String)"If you are sharing this report, please share it in full, including the JVM version, OS flavor and version, plus some data on used hardware.", (int)80, (int)2);
        pw.println();
        pw.println("  Use -h to get help on available options.");
        pw.println();
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new OptionFormatter());
        ArgumentAcceptingOptionSpec optTests = parser.accepts("t", "Test names.").withRequiredArg().ofType(Test.class).withValuesSeparatedBy(',').describedAs("string").defaultsTo((Object[])Test.values());
        ArgumentAcceptingOptionSpec optMode = parser.accepts("m", "Running mode, one of " + Arrays.toString((Object[])Mode.values()) + ".").withRequiredArg().ofType(Mode.class).describedAs("mode").defaultsTo((Object)Mode.normal, (Object[])new Mode[0]);
        parser.accepts("h", "Print help.");
        try {
            OptionSet set = parser.parse(args);
            if (set.has("h")) {
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            tests = set.valuesOf((OptionSpec)optTests);
            mode = (Mode)((Object)set.valueOf((OptionSpec)optMode));
        }
        catch (OptionException e) {
            String message = e.getMessage();
            Throwable cause = e.getCause();
            if (cause instanceof ValueConversionException) {
                message = message + ". " + cause.getMessage();
            }
            throw new CommandLineOptionException(message, (Throwable)e);
        }
        Options opts = new OptionsBuilder().detectJvmArgs().jvmArgsAppend(new String[]{"-Xmx512m", "-Xms512m", "-server"}).build();
        switch (mode) {
            case flash: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(3).warmupTime(TimeValue.milliseconds((long)10L)).measurementIterations(3).measurementTime(TimeValue.milliseconds((long)10L)).forks(1).build();
                break;
            }
            case quick: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(3).warmupTime(TimeValue.milliseconds((long)100L)).measurementIterations(3).measurementTime(TimeValue.milliseconds((long)100L)).forks(3).build();
                break;
            }
            case normal: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(5).warmupTime(TimeValue.milliseconds((long)500L)).measurementIterations(5).measurementTime(TimeValue.milliseconds((long)500L)).forks(5).build();
                break;
            }
            case longer: {
                opts = new OptionsBuilder().parent(opts).warmupIterations(10).warmupTime(TimeValue.seconds((long)1L)).measurementIterations(10).measurementTime(TimeValue.seconds((long)1L)).forks(10).build();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        block26: for (Test t : tests) {
            switch (t) {
                case timing: {
                    new TimingMeasurementsTest().runWith(pw, opts);
                    continue block26;
                }
                case stability: {
                    new ScoreStabilityTest().runWith(pw, opts);
                    continue block26;
                }
                case compiler_hints: {
                    new CompilerHintsTest().runWith(pw, opts);
                    continue block26;
                }
                case thermal: {
                    switch (mode) {
                        case flash: {
                            new ThermalRundownTest(3).runWith(pw, opts);
                            continue block26;
                        }
                        case quick: {
                            new ThermalRundownTest(5).runWith(pw, opts);
                            continue block26;
                        }
                        case normal: {
                            new ThermalRundownTest(18).runWith(pw, opts);
                            continue block26;
                        }
                        case longer: {
                            new ThermalRundownTest(60).runWith(pw, opts);
                            continue block26;
                        }
                    }
                    throw new IllegalStateException();
                }
                case helpers: {
                    new HelperMethodsTest().runWith(pw, opts);
                    continue block26;
                }
                case thread_scale: {
                    new ThreadScalingTest().runWith(pw, opts);
                    continue block26;
                }
                case blackhole_cpu: {
                    new BlackholeConsumeCPUTest().runWith(pw, opts);
                    continue block26;
                }
                case blackhole_single: {
                    new BlackholeSingleTest().runWith(pw, opts);
                    continue block26;
                }
                case blackhole_pipelined: {
                    Main.setBlackholeInline(false);
                    new BlackholePipelinedTest(false, false).runWith(pw, opts);
                    new BlackholePipelinedTest(true, false).runWith(pw, opts);
                    Main.setBlackholeInline(true);
                    new BlackholePipelinedTest(false, true).runWith(pw, opts);
                    new BlackholePipelinedTest(true, true).runWith(pw, opts);
                    Main.setBlackholeInline(false);
                    continue block26;
                }
                case blackhole_consec: {
                    Main.setBlackholeInline(false);
                    new BlackholeConsecutiveTest(false).runWith(pw, opts);
                    Main.setBlackholeInline(true);
                    new BlackholeConsecutiveTest(true).runWith(pw, opts);
                    Main.setBlackholeInline(false);
                    continue block26;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static void setBlackholeInline(boolean inline) {
        System.getProperties().setProperty("jmh.blackhole.forceInline", String.valueOf(inline));
        try {
            Field f = CompilerHints.class.getDeclaredField("hintsFile");
            f.setAccessible(true);
            f.set(null, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum Mode {
        flash,
        quick,
        normal,
        longer;

    }

    public static enum Test {
        timing,
        compiler_hints,
        thermal,
        stability,
        thread_scale,
        helpers,
        blackhole_cpu,
        blackhole_single,
        blackhole_pipelined,
        blackhole_consec;

    }
}

