/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import java.util.Arrays;
import org.openjdk.jmh.benchmarks.BlackholeConsecutiveBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class BlackholeConsecutiveTest
implements ValidationTest {
    private final boolean inlined;

    public BlackholeConsecutiveTest(boolean inlined) {
        this.inlined = inlined;
    }

    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- BLACKHOLE MERGING TEST" + (!this.inlined ? " (NORMAL)" : " (INLINE HINTS BROKEN)"));
        pw.println();
        Utils.reflow((PrintWriter)pw, (String)"This test verifies that calling the Blackhole.consume with the same result is not susceptible for merging. We expect the similar performance across all data types, and the number of consecutive calls. If there are significant differences, this is indicative of Blackhole failure, and it is a serious JMH issue.", (int)80, (int)2);
        pw.println();
        if (this.inlined) {
            Utils.reflow((PrintWriter)pw, (String)"This particular test mode forces the inline of Blackhole methods, and so demolishes one of the layers in defence in depth. If this layer is broken, Blackhole should also survive. If it isn't, then JMH will have to provide more contingencies.", (int)80, (int)2);
            pw.println();
        }
        String[] types = new String[]{"boolean", "byte", "short", "char", "int", "float", "long", "double", "Object", "Array"};
        int[] ss = new int[]{1, 4, 8};
        pw.println("  Scores are nanoseconds per Blackhole call.");
        pw.println("  Trying " + Arrays.toString(ss) + " consecutive Blackhole calls.");
        pw.println();
        pw.printf("%12s", "");
        for (int steps : ss) {
            pw.printf("%20s", steps);
        }
        pw.println();
        for (String type : types) {
            pw.printf("%12s", type + ": ");
            for (int steps : ss) {
                Options opts = new OptionsBuilder().parent(parent).include(BlackholeConsecutiveBench.class.getCanonicalName() + ".test_" + type + "_" + steps).param("steps", new String[]{String.valueOf(steps)}).verbosity(VerboseMode.SILENT).build();
                RunResult result = new Runner(opts).runSingle();
                Result r = result.getPrimaryResult();
                pw.printf("%20s", String.format("%.2f \u00b1 %.2f", r.getScore() / (double)steps, r.getScoreError() / (double)steps));
                pw.flush();
            }
            pw.println();
        }
        pw.println();
    }
}

