/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.benchmarks.EmptyBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class HelperMethodsTest
implements ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- HELPER METHOD TEST");
        pw.println();
        Utils.reflow((PrintWriter)pw, (String)"These tests show the overheads of using the benchmark methods. Normally, only Level.Invocation helpers should affect the benchmark performance, since other helpers execute outside the benchmark path.", (int)80, (int)2);
        pw.println();
        Options opts = new OptionsBuilder().parent(parent).include(EmptyBench.class.getCanonicalName()).verbosity(VerboseMode.SILENT).build();
        RunResult result = new Runner(opts).runSingle();
        Result r = result.getPrimaryResult();
        pw.printf("%51s", "running empty benchmark: ");
        pw.flush();
        pw.printf("%.2f \u00b1 %.2f ns\n", r.getScore(), r.getScoreError());
        pw.println();
        for (Scope scope : Scope.values()) {
            for (Level level : Level.values()) {
                for (String helper : new String[]{"Setup", "TearDown"}) {
                    Options opts2 = new OptionsBuilder().parent(parent).include("Level" + level + "Bench" + "." + scope.name().toLowerCase() + "_" + helper.toLowerCase() + "$").verbosity(VerboseMode.SILENT).build();
                    RunResult result2 = new Runner(opts2).runSingle();
                    Result r2 = result2.getPrimaryResult();
                    pw.printf("%20s, %16s, %10s: ", "Scope." + scope, "Level." + level, "@" + helper);
                    pw.flush();
                    pw.printf("%.2f \u00b1 %.2f ns\n", r2.getScore(), r2.getScoreError());
                }
            }
            pw.println();
        }
        pw.println();
    }
}

