/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeSet;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.benchmarks.ThreadScalingBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class ThreadScalingTest
implements ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        int max;
        pw.println("--------- THREAD SCALING TEST");
        pw.println();
        Utils.reflow((PrintWriter)pw, (String)("This test verifies the performance when scaling in multiple threads. In " + Mode.Throughput + " mode, the benchmark should scale almost linearly, at least before " + "the number of physical cores is reached. In other modes, the timings for individual ops should " + "stay roughly the same, at least before the number of physical cores is reached. The departure " + "from the expected behavior might be indicative of scheduling irregularities, power saving " + "features being enabled, process affinity enforced in virtualized environments, etc. -- these may " + "potentially disrupt multi-threaded benchmarks correctness."), (int)80, (int)2);
        pw.println();
        pw.println("  Scores are relative to a single-threaded case.");
        pw.println("  Threads are scaled from 1 to the number of hardware threads.");
        pw.println();
        TreeSet<Integer> threads = new TreeSet<Integer>();
        for (int t = max = Utils.figureOutHotCPUs(); t > 0; t /= 2) {
            threads.add(t);
        }
        threads.add(1);
        threads.add(2);
        pw.printf("%20s", "");
        Mode[] modeArray = threads.iterator();
        while (modeArray.hasNext()) {
            int delay = (Integer)modeArray.next();
            pw.printf("%16s", delay);
        }
        pw.println();
        for (Mode m : Mode.values()) {
            if (m == Mode.All) continue;
            pw.printf("%20s", m + ": ");
            double base = 0.0;
            double baseError = 0.0;
            Iterator iterator = threads.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                Options opts = new OptionsBuilder().parent(parent).mode(m).include(ThreadScalingBench.class.getCanonicalName()).verbosity(VerboseMode.SILENT).threads(t).build();
                RunResult result = new Runner(opts).runSingle();
                Result r = result.getPrimaryResult();
                double score = r.getScore();
                double error = r.getScoreError();
                if (t == 1) {
                    base = score;
                    baseError = error;
                }
                double f = score / base;
                double f_err = Math.sqrt(Math.pow(error, 2.0) + Math.pow(f, 2.0) * Math.pow(baseError, 2.0)) / base;
                pw.printf("%16s", String.format("%.2fx \u00b1 %.2fx", f, f_err));
                pw.flush();
            }
            pw.println();
        }
        pw.println();
    }
}

