/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.validation.tests;

import java.io.PrintWriter;
import org.openjdk.jmh.benchmarks.NanoTimerBench;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;
import org.openjdk.jmh.validation.ValidationTest;

public class TimingMeasurementsTest
implements ValidationTest {
    @Override
    public void runWith(PrintWriter pw, Options parent) throws RunnerException {
        pw.println("--------- TIMING MEASUREMENTS TEST");
        pw.println();
        Utils.reflow((PrintWriter)pw, (String)"This test shows the minimal individual timings possible to measure. This normally affects only SampleTime and SingleShot benchmark modes. Throughput/AverageTime tests can do better since they do only a few timestamps before and after the complete iteration.", (int)80, (int)2);
        pw.println();
        Options opts = new OptionsBuilder().parent(parent).include(NanoTimerBench.class.getCanonicalName() + ".latency$").verbosity(VerboseMode.SILENT).build();
        RunResult result = new Runner(opts).runSingle();
        Result r = result.getPrimaryResult();
        pw.printf("%50s", "System.nanoTime latency: ");
        pw.flush();
        pw.printf("%.2f \u00b1 %.2f ns\n", r.getScore(), r.getScoreError());
        opts = new OptionsBuilder().parent(parent).include(NanoTimerBench.class.getCanonicalName() + ".granularity$").verbosity(VerboseMode.SILENT).build();
        result = new Runner(opts).runSingle();
        r = result.getPrimaryResult();
        pw.printf("%50s", "System.nanoTime granularity: ");
        pw.flush();
        pw.printf("%.2f \u00b1 %.2f ns\n", r.getScore(), r.getScoreError());
        pw.println();
    }
}

