/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

@FunctionalInterface
public interface Subscription {
    public static final Subscription EMPTY = () -> {};

    public void unsubscribe();

    default public Subscription and(Subscription subscription) {
        Objects.requireNonNull(subscription);
        return () -> {
            this.unsubscribe();
            subscription.unsubscribe();
        };
    }

    public static <T> Subscription subscribe(ObservableValue<T> observableValue2, Consumer<? super T> consumer) {
        Objects.requireNonNull(observableValue2);
        Objects.requireNonNull(consumer);
        ChangeListener<Object> changeListener = (observableValue, object, object2) -> consumer.accept(object2);
        consumer.accept(observableValue2.getValue());
        observableValue2.addListener(changeListener);
        return () -> observableValue2.removeListener(changeListener);
    }

    public static Subscription subscribeInvalidations(ObservableValue<?> observableValue, Runnable runnable) {
        Objects.requireNonNull(observableValue);
        Objects.requireNonNull(runnable);
        InvalidationListener invalidationListener = observable -> runnable.run();
        observableValue.addListener(invalidationListener);
        return () -> observableValue.removeListener(invalidationListener);
    }
}

