/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import fj.data.Option;
import java.util.function.Function;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.dataflow.ExpressionDataFlowNode;
import org.openrewrite.analysis.dataflow.ParameterDataFlowNode;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.ExprParent;
import org.openrewrite.analysis.trait.variable.Parameter;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public abstract class DataFlowNode {
    final Cursor cursor;

    public abstract Option<Expr> asExpr();

    public <E extends Expr> Option<E> asExpr(Class<E> clazz) {
        return this.asExpr().filter(clazz::isInstance).map(clazz::cast);
    }

    public <E extends ExprParent> Option<E> asExprParent(Class<E> clazz) {
        return this.asExpr().filter(clazz::isInstance).map(clazz::cast);
    }

    public abstract Option<Parameter> asParameter();

    public boolean isParameter() {
        return this.asParameter().isSome();
    }

    public boolean isExpr() {
        return this.asExpr().isSome();
    }

    abstract <T> T map(Function<Expr, T> var1, Function<Parameter, T> var2);

    public static Option<DataFlowNode> of(Cursor cursor) {
        if (cursor.getValue() instanceof Expression) {
            return Expr.viewOf(cursor).toOption().map(expr -> new ExpressionDataFlowNode(cursor, (Expr)expr));
        }
        if (cursor.getValue() instanceof J.VariableDeclarations.NamedVariable) {
            return Parameter.viewOf(cursor).map(parameter -> new ParameterDataFlowNode(cursor, (Parameter)parameter)).toOption();
        }
        return Option.none();
    }

    public static DataFlowNode ofOrThrow(Cursor cursor, String message) {
        Option<DataFlowNode> maybeNode = DataFlowNode.of(cursor);
        if (maybeNode.isNone()) {
            throw new RuntimeException(message);
        }
        return (DataFlowNode)maybeNode.some();
    }

    @Generated
    DataFlowNode(Cursor cursor) {
        this.cursor = cursor;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }
}

