/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.charset.Charset;
import java.nio.file.Path;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public interface SourceFile
extends Tree {
    public Path getSourcePath();

    public SourceFile withSourcePath(Path var1);

    public Charset getCharset();

    public SourceFile withCharset(Charset var1);

    public boolean isCharsetBomMarked();

    public SourceFile withCharsetBomMarked(boolean var1);

    public Markers getMarkers();

    public <T extends SourceFile> T withMarkers(Markers var1);

    @Nullable
    default public <S extends Style> S getStyle(Class<S> style) {
        return NamedStyles.merge(style, this.getMarkers().findAll(NamedStyles.class));
    }

    default public <P> byte[] printAllAsBytes(P p) {
        return this.printAll(p).getBytes(this.getCharset());
    }

    default public byte[] printAllAsBytes() {
        return this.printAllAsBytes(0);
    }

    default public <P> String printAll(P p) {
        return this.print(p, new Cursor(null, this));
    }

    default public String printAll() {
        return this.printAll(0);
    }

    default public <P> String printAllTrimmed(P p) {
        return this.printTrimmed(p, new Cursor(null, this));
    }

    default public String printAllTrimmed() {
        return this.printAllTrimmed(0);
    }

    @Override
    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        throw new UnsupportedOperationException("SourceFile implementations should override this method");
    }
}

