/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;

public class DeclarativeRecipe
extends Recipe {
    private final String name;
    private final String displayName;
    private final String description;
    private final Set<String> tags;
    @Nullable
    private final Duration estimatedEffortPerOccurrence;
    private final URI source;
    private final List<String> lazyNext = new ArrayList<String>();
    @JsonIgnore
    private Validated validation = Validated.test("initialization", "initialize(..) must be called on DeclarativeRecipe prior to use.", this, r -> this.lazyNext.isEmpty());

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    void initialize(Collection<Recipe> availableRecipes) {
        for (int i = 0; i < this.lazyNext.size(); ++i) {
            String nextName = this.lazyNext.get(i);
            Optional<Recipe> next = availableRecipes.stream().filter(r -> r.getName().equals(nextName)).findAny();
            if (next.isPresent()) {
                this.doNext(next.get());
                continue;
            }
            this.validation = this.validation.and(Validated.invalid(this.name + ".recipeList[" + i + "] (in " + this.source + ")", nextName, "recipe '" + nextName + "' does not exist.", null));
        }
        this.lazyNext.clear();
    }

    void doNext(String recipeName) {
        try {
            this.doNext((Recipe)Class.forName(recipeName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            this.lazyNext.add(recipeName);
        }
    }

    void addValidation(Validated validated) {
        this.validation = this.validation.and(validated);
    }

    @Override
    public Validated validate() {
        return this.validation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public DeclarativeRecipe(String name, String displayName, String description, Set<String> tags, @Nullable Duration estimatedEffortPerOccurrence, URI source) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.source = source;
    }
}

