/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class LanguageComposition
extends DataTable<Row> {
    public LanguageComposition(Recipe recipe) {
        super(recipe, "Language composition", "A list of files and their language composition.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file.")
        private final String sourcePath;
        @Column(displayName="Language", description="The language of the source file.")
        private final String language;
        @Column(displayName="Weight", description="The weight of the source file, in terms of total number of AST nodes, markers, and type attribution nodes.")
        private final Long weight;
        @Column(displayName="Lines of code", description="The number of lines of code in the source file.")
        private final Integer linesOfCode;

        public Row(String sourcePath, String language, Long weight, Integer linesOfCode) {
            this.sourcePath = sourcePath;
            this.language = language;
            this.weight = weight;
            this.linesOfCode = linesOfCode;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getLanguage() {
            return this.language;
        }

        public Long getWeight() {
            return this.weight;
        }

        public Integer getLinesOfCode() {
            return this.linesOfCode;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Long this$weight = this.getWeight();
            Long other$weight = other.getWeight();
            if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
                return false;
            }
            Integer this$linesOfCode = this.getLinesOfCode();
            Integer other$linesOfCode = other.getLinesOfCode();
            if (this$linesOfCode == null ? other$linesOfCode != null : !((Object)this$linesOfCode).equals(other$linesOfCode)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            return !(this$language == null ? other$language != null : !this$language.equals(other$language));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $weight = this.getWeight();
            result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
            Integer $linesOfCode = this.getLinesOfCode();
            result = result * 59 + ($linesOfCode == null ? 43 : ((Object)$linesOfCode).hashCode());
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "LanguageComposition.Row(sourcePath=" + this.getSourcePath() + ", language=" + this.getLanguage() + ", weight=" + this.getWeight() + ", linesOfCode=" + this.getLinesOfCode() + ")";
        }
    }
}

