/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal.lang;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openrewrite.internal.lang.NonNull;

public class NullUtils {
    private static final List<String> PACKAGE_LEVEL_NON_NULL_ANNOTATIONS = Collections.singletonList("NonNullFields");
    private static List<String> FIELD_LEVEL_NON_NULL_ANNOTATIONS = Arrays.asList("NonNull", "Nonnull", "NotNull");
    private static List<String> FIELD_LEVEL_NULLABLE_ANNOTATIONS = Collections.singletonList("Nullable");

    public static List<Field> findNonNullFields(@NonNull Class<?> _class) {
        boolean defaultNonNull = Arrays.stream(_class.getPackage().getDeclaredAnnotations()).map(a -> a.annotationType().getSimpleName()).anyMatch(PACKAGE_LEVEL_NON_NULL_ANNOTATIONS::contains);
        Field[] fields = _class.getDeclaredFields();
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Field> nonNullFields = new ArrayList<Field>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            if (!NullUtils.fieldHasNonNullableAnnotation(field) && (!defaultNonNull || NullUtils.fieldHasNullableAnnotation(field))) continue;
            nonNullFields.add(field);
        }
        nonNullFields.sort(Comparator.comparing(Field::getName));
        return nonNullFields;
    }

    private static boolean fieldHasNonNullableAnnotation(Field field) {
        return Arrays.stream(field.getDeclaredAnnotations()).map(a -> a.annotationType().getSimpleName()).anyMatch(FIELD_LEVEL_NON_NULL_ANNOTATIONS::contains);
    }

    private static boolean fieldHasNullableAnnotation(Field field) {
        return Arrays.stream(field.getDeclaredAnnotations()).map(a -> a.annotationType().getSimpleName()).anyMatch(FIELD_LEVEL_NULLABLE_ANNOTATIONS::contains);
    }
}

