/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class AppendToTextFile
extends Recipe {
    @Option(displayName="Relative File Name", description="File name, using a relative path. If a non-plaintext file already exists at this location, then this recipe will do nothing.", example="foo/bar/baz.txt")
    private final String relativeFileName;
    @Option(displayName="Content", description="Multiline text content to be appended to the file.", example="Some text.")
    private final String content;
    @Option(displayName="Preamble", description="If creating this file fresh, then this content will be included at the beginning. Default nothing.", example="# File generated by OpenRewrite #", required=false)
    @Nullable
    private final String preamble;
    @Option(displayName="Append newline", description="Print a newline automatically after the content (and preamble). Default true.", required=false)
    @Nullable
    private final Boolean appendNewline;
    @Option(displayName="Existing file strategy", description="Determines behavior if a file exists at this location prior to Rewrite execution.\n\n- `continue`: append new content to existing file contents. If existing file is not plaintext, recipe does nothing.\n- `replace`: remove existing content from file.\n- `leave`: *(default)* do nothing. Existing file is fully preserved.\n\nNote: this only affects the first interaction with the specified file per Rewrite execution.\nSubsequent instances of this recipe in the same Rewrite execution will always append.", valid={"continue", "replace", "leave"}, required=false)
    @Nullable
    private final String existingFileStrategy;
    private static final String CREATED_THIS_EXECUTION_MESSAGE_KEY = "AppendToTextFile.CreatedThisExecution";
    private final String alreadyVisitedMessageKey = "AppendToTextFile.AlreadyVisitedBy." + Tree.randomId();

    @Override
    public String getDisplayName() {
        return "Append to text file";
    }

    @Override
    public String getDescription() {
        return "Appends content to a plaintext file. Multiple instances of this recipe in the same execution context can all contribute.";
    }

    @Override
    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        String maybeNewline = !Boolean.FALSE.equals(this.appendNewline) ? "\n" : "";
        return this.visit(before, ctx, this.relativeFileName, this.content + maybeNewline, this.preamble != null ? this.preamble + maybeNewline : "", this.existingFileStrategy != null ? Strategy.valueOf(this.existingFileStrategy.toUpperCase()) : Strategy.LEAVE);
    }

    private List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx, String path, String content, String preamble, Strategy strategy) {
        SourceFile sourceFile = null;
        for (SourceFile it : before) {
            if (!it.getSourcePath().toString().equals(Paths.get(path, new String[0]).toString())) continue;
            sourceFile = it;
            break;
        }
        if (sourceFile == null) {
            return ListUtils.concat(before, this.createFile(path, preamble + content, ctx, null));
        }
        if (this.isAlreadyVisited(sourceFile, ctx) || !(sourceFile instanceof PlainText)) {
            return before;
        }
        PlainText existingPlainText = (PlainText)sourceFile;
        if (this.isCreatedInThisExecution(existingPlainText, ctx)) {
            return this.replace(before, existingPlainText, this.withAppend(existingPlainText, content, ctx));
        }
        switch (strategy) {
            case CONTINUE: {
                return this.replace(before, existingPlainText, this.withAppend(existingPlainText, content, ctx));
            }
            case REPLACE: {
                return this.replace(before, existingPlainText, this.createFile(path, preamble + content, ctx, existingPlainText.getId()));
            }
            case LEAVE: {
                return before;
            }
        }
        throw new IllegalArgumentException();
    }

    private List<SourceFile> replace(List<SourceFile> before, SourceFile existingFile, PlainText newFile) {
        ArrayList<SourceFile> after = new ArrayList<SourceFile>(before);
        after.remove(existingFile);
        after.add(newFile);
        return after;
    }

    private PlainText withAppend(PlainText before, String content, ExecutionContext ctx) {
        PlainText after = before.withText(before.getText() + content);
        this.alreadyVisited(after, ctx);
        return after;
    }

    private PlainText createFile(String path, String content, ExecutionContext ctx, @Nullable UUID id) {
        PlainText plainText = ((PlainText)new PlainTextParser().parse(content).get(0)).withSourcePath(Paths.get(path, new String[0]));
        if (id != null) {
            plainText = plainText.withId(id);
        }
        this.createdInThisExecution(plainText, ctx);
        return plainText;
    }

    private boolean isCreatedInThisExecution(SourceFile sourceFile, ExecutionContext ctx) {
        Set createdSet = (Set)ctx.getMessage(CREATED_THIS_EXECUTION_MESSAGE_KEY);
        return createdSet != null && createdSet.contains(sourceFile.getId());
    }

    private void createdInThisExecution(SourceFile sourceFile, ExecutionContext ctx) {
        ctx.putMessageInSet(CREATED_THIS_EXECUTION_MESSAGE_KEY, sourceFile.getId());
        this.alreadyVisited(sourceFile, ctx);
    }

    private boolean isAlreadyVisited(SourceFile sourceFile, ExecutionContext ctx) {
        Set alreadyVisitedSet = (Set)ctx.getMessage(this.alreadyVisitedMessageKey);
        return alreadyVisitedSet != null && alreadyVisitedSet.contains(sourceFile.getId());
    }

    private void alreadyVisited(SourceFile sourceFile, ExecutionContext ctx) {
        ctx.putMessageInSet(this.alreadyVisitedMessageKey, sourceFile.getId());
    }

    public AppendToTextFile(String relativeFileName, String content, @Nullable String preamble, @Nullable Boolean appendNewline, @Nullable String existingFileStrategy) {
        this.relativeFileName = relativeFileName;
        this.content = content;
        this.preamble = preamble;
        this.appendNewline = appendNewline;
        this.existingFileStrategy = existingFileStrategy;
    }

    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    public String getContent() {
        return this.content;
    }

    @Nullable
    public String getPreamble() {
        return this.preamble;
    }

    @Nullable
    public Boolean getAppendNewline() {
        return this.appendNewline;
    }

    @Nullable
    public String getExistingFileStrategy() {
        return this.existingFileStrategy;
    }

    public String getAlreadyVisitedMessageKey() {
        return this.alreadyVisitedMessageKey;
    }

    @NonNull
    public String toString() {
        return "AppendToTextFile(relativeFileName=" + this.getRelativeFileName() + ", content=" + this.getContent() + ", preamble=" + this.getPreamble() + ", appendNewline=" + this.getAppendNewline() + ", existingFileStrategy=" + this.getExistingFileStrategy() + ", alreadyVisitedMessageKey=" + this.getAlreadyVisitedMessageKey() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppendToTextFile)) {
            return false;
        }
        AppendToTextFile other = (AppendToTextFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$appendNewline = this.getAppendNewline();
        Boolean other$appendNewline = other.getAppendNewline();
        if (this$appendNewline == null ? other$appendNewline != null : !((Object)this$appendNewline).equals(other$appendNewline)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$preamble = this.getPreamble();
        String other$preamble = other.getPreamble();
        if (this$preamble == null ? other$preamble != null : !this$preamble.equals(other$preamble)) {
            return false;
        }
        String this$existingFileStrategy = this.getExistingFileStrategy();
        String other$existingFileStrategy = other.getExistingFileStrategy();
        if (this$existingFileStrategy == null ? other$existingFileStrategy != null : !this$existingFileStrategy.equals(other$existingFileStrategy)) {
            return false;
        }
        String this$alreadyVisitedMessageKey = this.getAlreadyVisitedMessageKey();
        String other$alreadyVisitedMessageKey = other.getAlreadyVisitedMessageKey();
        return !(this$alreadyVisitedMessageKey == null ? other$alreadyVisitedMessageKey != null : !this$alreadyVisitedMessageKey.equals(other$alreadyVisitedMessageKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AppendToTextFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $appendNewline = this.getAppendNewline();
        result = result * 59 + ($appendNewline == null ? 43 : ((Object)$appendNewline).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $preamble = this.getPreamble();
        result = result * 59 + ($preamble == null ? 43 : $preamble.hashCode());
        String $existingFileStrategy = this.getExistingFileStrategy();
        result = result * 59 + ($existingFileStrategy == null ? 43 : $existingFileStrategy.hashCode());
        String $alreadyVisitedMessageKey = this.getAlreadyVisitedMessageKey();
        result = result * 59 + ($alreadyVisitedMessageKey == null ? 43 : $alreadyVisitedMessageKey.hashCode());
        return result;
    }

    public static enum Strategy {
        CONTINUE,
        REPLACE,
        LEAVE;

    }
}

