/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class TeamcityBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String projectName;
    private final String buildNumber;
    private final String buildUrl;
    private final String version;

    public static TeamcityBuildEnvironment build(UnaryOperator<String> environment) {
        return new TeamcityBuildEnvironment(Tree.randomId(), (String)environment.apply("TEAMCITY_PROJECT_NAME"), (String)environment.apply("BUILD_NUMBER"), (String)environment.apply("BUILD_URL"), (String)environment.apply("TEAMCITY_VERSION"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        throw new IncompleteGitConfigException();
    }

    public TeamcityBuildEnvironment(UUID id, String projectName, String buildNumber, String buildUrl, String version) {
        this.id = id;
        this.projectName = projectName;
        this.buildNumber = buildNumber;
        this.buildUrl = buildUrl;
        this.version = version;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getBuildUrl() {
        return this.buildUrl;
    }

    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "TeamcityBuildEnvironment(id=" + this.getId() + ", projectName=" + this.getProjectName() + ", buildNumber=" + this.getBuildNumber() + ", buildUrl=" + this.getBuildUrl() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeamcityBuildEnvironment)) {
            return false;
        }
        TeamcityBuildEnvironment other = (TeamcityBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$buildNumber = this.getBuildNumber();
        String other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) {
            return false;
        }
        String this$buildUrl = this.getBuildUrl();
        String other$buildUrl = other.getBuildUrl();
        if (this$buildUrl == null ? other$buildUrl != null : !this$buildUrl.equals(other$buildUrl)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $buildNumber = this.getBuildNumber();
        result = result * 59 + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        String $buildUrl = this.getBuildUrl();
        result = result * 59 + ($buildUrl == null ? 43 : $buildUrl.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @NonNull
    public TeamcityBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new TeamcityBuildEnvironment(id, this.projectName, this.buildNumber, this.buildUrl, this.version);
    }
}

