/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RenameFile
extends Recipe {
    @Option(displayName="File matcher", description="Matching files will be renamed. This is a glob expression.", example="**/application-*.yml")
    private final String fileMatcher;
    @Option(displayName="The renamed file name", description="Just the file name without the folder path that precedes it.", example="application.yml")
    private final String fileName;

    @Override
    public String getDisplayName() {
        return "Rename a file";
    }

    @Override
    public String getDescription() {
        return "Rename a file while keeping it in the same directory.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                Path sourcePath;
                PathMatcher pathMatcher;
                if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher("glob:" + RenameFile.this.fileMatcher)).matches(sourcePath)) {
                    return ((SourceFile)tree).withSourcePath(sourcePath.resolveSibling(RenameFile.this.fileName).normalize());
                }
                return super.visit(tree, ctx);
            }
        };
    }

    public RenameFile(String fileMatcher, String fileName) {
        this.fileMatcher = fileMatcher;
        this.fileName = fileName;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public String getFileName() {
        return this.fileName;
    }

    @NonNull
    public String toString() {
        return "RenameFile(fileMatcher=" + this.getFileMatcher() + ", fileName=" + this.getFileName() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameFile)) {
            return false;
        }
        RenameFile other = (RenameFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        if (this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RenameFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        return result;
    }
}

