/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tree;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.UUID;
import lombok.Generated;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseErrorPrinter;
import org.openrewrite.ParseErrorVisitor;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;

public final class ParseError
implements SourceFile {
    private final UUID id;
    private final Markers markers;
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    @Nullable
    private final String charsetName;
    private final boolean charsetBomMarked;
    @Nullable
    private final Checksum checksum;
    private final String text;
    @Nullable
    private final SourceFile erroneous;

    @Override
    public Charset getCharset() {
        return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
    }

    @Override
    public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new ParseErrorPrinter();
    }

    public SourceFile withCharset(Charset charset) {
        return this.withCharsetName(charset.name());
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(ParseErrorVisitor.class);
    }

    @Override
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)v.adapt(ParseErrorVisitor.class).visitParseError(this, p);
    }

    public static ParseError build(Parser parser, Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx, Throwable t) {
        EncodingDetectingInputStream is = input.getSource(ctx);
        return new ParseError(Tree.randomId(), new Markers(Tree.randomId(), Collections.singletonList(ParseExceptionResult.build(parser, t))), input.getRelativePath(relativeTo), input.getFileAttributes(), parser.getCharset(ctx).name(), is.isCharsetBomMarked(), null, is.readFully(), null);
    }

    public IllegalStateException toException() {
        if (this.getErroneous() != null) {
            return new IllegalStateException("Failed to parse " + this.getSourcePath() + " because of parse-to-print idempotence on: " + this.getText());
        }
        ParseExceptionResult ex = this.getMarkers().findFirst(ParseExceptionResult.class).orElseThrow(() -> new IllegalStateException("No ParseExceptionResult marker on parser failure"));
        return new IllegalStateException(ex.getExceptionType() + ": " + ex.getMessage());
    }

    @Generated
    public ParseError(UUID id, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, String text, @Nullable SourceFile erroneous) {
        this.id = id;
        this.markers = markers;
        this.sourcePath = sourcePath;
        this.fileAttributes = fileAttributes;
        this.charsetName = charsetName;
        this.charsetBomMarked = charsetBomMarked;
        this.checksum = checksum;
        this.text = text;
        this.erroneous = erroneous;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @Override
    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    @Nullable
    @Generated
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Nullable
    @Generated
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    @Generated
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Nullable
    @Generated
    public Checksum getChecksum() {
        return this.checksum;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Nullable
    @Generated
    public SourceFile getErroneous() {
        return this.erroneous;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseError)) {
            return false;
        }
        ParseError other = (ParseError)o;
        if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        FileAttributes this$fileAttributes = this.getFileAttributes();
        FileAttributes other$fileAttributes = other.getFileAttributes();
        if (this$fileAttributes == null ? other$fileAttributes != null : !((Object)this$fileAttributes).equals(other$fileAttributes)) {
            return false;
        }
        String this$charsetName = this.getCharsetName();
        String other$charsetName = other.getCharsetName();
        if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
            return false;
        }
        Checksum this$checksum = this.getChecksum();
        Checksum other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        SourceFile this$erroneous = this.getErroneous();
        SourceFile other$erroneous = other.getErroneous();
        return !(this$erroneous == null ? other$erroneous != null : !this$erroneous.equals(other$erroneous));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        FileAttributes $fileAttributes = this.getFileAttributes();
        result = result * 59 + ($fileAttributes == null ? 43 : ((Object)$fileAttributes).hashCode());
        String $charsetName = this.getCharsetName();
        result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
        Checksum $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        SourceFile $erroneous = this.getErroneous();
        result = result * 59 + ($erroneous == null ? 43 : $erroneous.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ParseError(id=" + this.getId() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", text=" + this.getText() + ", erroneous=" + this.getErroneous() + ")";
    }

    @NonNull
    @Generated
    public ParseError withId(UUID id) {
        return this.id == id ? this : new ParseError(id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withMarkers(Markers markers) {
        return this.markers == markers ? this : new ParseError(this.id, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new ParseError(this.id, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new ParseError(this.id, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withText(String text) {
        return this.text == text ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, text, this.erroneous);
    }

    @NonNull
    @Generated
    public ParseError withErroneous(@Nullable SourceFile erroneous) {
        return this.erroneous == erroneous ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.text, erroneous);
    }

    @NonNull
    @Generated
    private ParseError withCharsetName(@Nullable String charsetName) {
        return this.charsetName == charsetName ? this : new ParseError(this.id, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.text, this.erroneous);
    }
}

