/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.Remote;
import org.openrewrite.remote.RemoteArtifactCache;
import org.openrewrite.remote.RemoteExecutionContextView;

public final class RemoteFile
implements Remote {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    private final URI uri;
    private final @Nullable Charset charset;
    private final boolean charsetBomMarked;
    private final @Nullable FileAttributes fileAttributes;
    @Language(value="markdown")
    private final String description;
    private final @Nullable Checksum checksum;

    @Override
    public InputStream getInputStream(ExecutionContext ctx) {
        HttpSender httpSender = HttpSenderExecutionContextView.view(ctx).getLargeFileHttpSender();
        RemoteArtifactCache cache = RemoteExecutionContextView.view(ctx).getArtifactCache();
        try {
            Path localFile = cache.compute(this.uri, () -> {
                HttpSender.Response response = httpSender.get(this.uri.toString()).send();
                return response.getBody();
            }, ctx.getOnError());
            if (localFile == null) {
                throw new IllegalStateException("Failed to download " + this.uri + " to artifact cache");
            }
            return Files.newInputStream(localFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to download " + this.uri + " to temporary file", e);
        }
    }

    @Generated
    public RemoteFile(UUID id, Path sourcePath, Markers markers, URI uri, @Nullable Charset charset, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Language(value="markdown") String description, @Nullable Checksum checksum) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.uri = uri;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.description = description;
        this.checksum = checksum;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Override
    @Generated
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @Override
    @Generated
    public URI getUri() {
        return this.uri;
    }

    @Override
    @Generated
    public @Nullable Charset getCharset() {
        return this.charset;
    }

    @Override
    @Generated
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Generated
    public @Nullable FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    @Language(value="markdown")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public @Nullable Checksum getChecksum() {
        return this.checksum;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoteFile(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", uri=" + this.getUri() + ", charset=" + this.getCharset() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", description=" + this.getDescription() + ", checksum=" + this.getChecksum() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFile)) {
            return false;
        }
        RemoteFile other = (RemoteFile)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public RemoteFile withId(UUID id) {
        return this.id == id ? this : new RemoteFile(id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new RemoteFile(this.id, sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withMarkers(Markers markers) {
        return this.markers == markers ? this : new RemoteFile(this.id, this.sourcePath, markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withUri(URI uri) {
        return this.uri == uri ? this : new RemoteFile(this.id, this.sourcePath, this.markers, uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withCharset(@Nullable Charset charset) {
        return this.charset == charset ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, charset, this.charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, charsetBomMarked, this.fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, fileAttributes, this.description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withDescription(@Language(value="markdown") String description) {
        return this.description == description ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, description, this.checksum);
    }

    @NonNull
    @Generated
    public RemoteFile withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, checksum);
    }
}

