/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.ci.BitbucketBuildEnvironment;
import org.openrewrite.marker.ci.CircleCiBuildEnvironment;
import org.openrewrite.marker.ci.CustomBuildEnvironment;
import org.openrewrite.marker.ci.DroneBuildEnvironment;
import org.openrewrite.marker.ci.GithubActionsBuildEnvironment;
import org.openrewrite.marker.ci.GitlabBuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;
import org.openrewrite.marker.ci.JenkinsBuildEnvironment;
import org.openrewrite.marker.ci.TeamcityBuildEnvironment;
import org.openrewrite.marker.ci.TravisBuildEnvironment;

public interface BuildEnvironment
extends Marker {
    public static @Nullable BuildEnvironment build(UnaryOperator<String> environment) {
        if (environment.apply("BITBUCKET_COMMIT") != null) {
            return BitbucketBuildEnvironment.build(environment);
        }
        if (environment.apply("CUSTOM_CI") != null) {
            return CustomBuildEnvironment.build(environment);
        }
        if (environment.apply("BUILD_NUMBER") != null && environment.apply("JOB_NAME") != null) {
            return JenkinsBuildEnvironment.build(environment);
        }
        if (environment.apply("GITLAB_CI") != null) {
            return GitlabBuildEnvironment.build(environment);
        }
        if (environment.apply("CI") != null && environment.apply("GITHUB_ACTION") != null && environment.apply("GITHUB_RUN_ID") != null) {
            return GithubActionsBuildEnvironment.build(environment);
        }
        if (environment.apply("DRONE") != null) {
            return DroneBuildEnvironment.build(environment);
        }
        if (environment.apply("CIRCLECI") != null) {
            return CircleCiBuildEnvironment.build(environment);
        }
        if (environment.apply("TEAMCITY_VERSION") != null) {
            return TeamcityBuildEnvironment.build(environment);
        }
        if (environment.apply("TRAVIS") != null) {
            return TravisBuildEnvironment.build(environment);
        }
        return null;
    }

    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException;
}

