/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.trait.TypeReference;

@Incubating(since="8.39.0")
public interface SourceFileWithTypeReferences
extends SourceFile {
    public TypeReferences getTypeReferences();

    public static class TypeReferences {
        private final SourceFile sourceFile;
        private final Set<TypeReference> typeReferences;

        public Collection<TypeReference> findMatches(TypeReference.Matcher matcher) {
            ArrayList<TypeReference> list = new ArrayList<TypeReference>();
            for (TypeReference ref : this.typeReferences) {
                if (!ref.matches(matcher)) continue;
                list.add(ref);
            }
            return list;
        }

        public static TypeReferences build(SourceFile sourceFile) {
            HashSet<TypeReference> typeReferences = new HashSet<TypeReference>();
            ServiceLoader<TypeReference.Provider> loader = ServiceLoader.load(TypeReference.Provider.class);
            loader.forEach(provider -> {
                if (provider.isAcceptable(sourceFile)) {
                    typeReferences.addAll(provider.getTypeReferences(sourceFile));
                }
            });
            return new TypeReferences(sourceFile, typeReferences);
        }

        @Generated
        private TypeReferences(SourceFile sourceFile, Set<TypeReference> typeReferences) {
            this.sourceFile = sourceFile;
            this.typeReferences = typeReferences;
        }

        @Generated
        public SourceFile getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public Set<TypeReference> getTypeReferences() {
            return this.typeReferences;
        }
    }
}

