/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestRelease;

public class ExactVersionWithPattern
extends LatestRelease {
    private final String version;

    public ExactVersionWithPattern(String version, String metadataPattern) {
        super(metadataPattern);
        this.version = version;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return super.isValid(currentVersion, version) && super.compare(currentVersion, version, this.version) == 0;
    }

    public static Validated<ExactVersionWithPattern> build(String toVersion, @Nullable String metadataPattern) {
        if (StringUtils.isBlank(metadataPattern)) {
            return Validated.invalid("exactVersionWithPattern", metadataPattern, "metadataPattern is null or empty");
        }
        if (ExactVersion.build(toVersion).isInvalid()) {
            return Validated.invalid("exactVersionWithPattern", toVersion, "not an exact version number");
        }
        return Validated.valid("exactVersionWithPattern", new ExactVersionWithPattern(toVersion, metadataPattern));
    }
}

