/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.Reference;
import org.openrewrite.rpc.RpcObjectData;

public class RpcSendQueue {
    private final int batchSize;
    private final List<RpcObjectData> batch;
    private final Consumer<List<RpcObjectData>> drain;
    private final Map<Object, Integer> refs;
    private @Nullable Object before;

    public RpcSendQueue(int batchSize, ThrowingConsumer<List<RpcObjectData>> drain, Map<Object, Integer> refs) {
        this.batchSize = batchSize;
        this.batch = new ArrayList<RpcObjectData>(batchSize);
        this.drain = drain;
        this.refs = refs;
    }

    public void put(RpcObjectData rpcObjectData) {
        this.batch.add(rpcObjectData);
        if (this.batch.size() == this.batchSize) {
            this.flush();
        }
    }

    public void flush() {
        if (this.batch.isEmpty()) {
            return;
        }
        this.drain.accept(new ArrayList<RpcObjectData>(this.batch));
        this.batch.clear();
    }

    public <T> void sendMarkers(@Nullable T parent, Function<T, Markers> markersFn) {
        this.getAndSend(parent, t2 -> Reference.asRef(markersFn.apply(t2)), markersRef -> {
            Markers markers = (Markers)Reference.getValue(markersRef);
            this.getAndSendList(markers, Markers::getMarkers, Marker::getId, null);
        });
    }

    public <T, U> void getAndSend(@Nullable T parent, Function<T, @Nullable U> value) {
        this.getAndSend(parent, value, null);
    }

    public <T, U> void getAndSend(@Nullable T parent, Function<T, @Nullable U> value, @Nullable Consumer<U> onChange) {
        Object after = value.apply(parent);
        T before = this.before == null ? null : (T)value.apply(this.before);
        this.send(after, before, onChange == null ? null : () -> onChange.accept(after));
    }

    public <T, U> void getAndSendList(@Nullable T parent, Function<T, @Nullable List<U>> values, Function<U, ?> id, @Nullable Consumer<U> onChange) {
        List<U> after = values.apply(parent);
        List<U> before = this.before == null ? null : values.apply(this.before);
        this.sendList(after, before, id, onChange);
    }

    public <T> void send(@Nullable T after, @Nullable T before, @Nullable Runnable onChange) {
        Object afterVal = Reference.getValue(after);
        Object beforeVal = Reference.getValue(before);
        if (beforeVal == afterVal) {
            this.put(new RpcObjectData(RpcObjectData.State.NO_CHANGE, null, null, null));
        } else if (beforeVal == null) {
            this.add(after, onChange);
        } else if (afterVal == null) {
            this.put(new RpcObjectData(RpcObjectData.State.DELETE, null, null, null));
        } else {
            this.put(new RpcObjectData(RpcObjectData.State.CHANGE, null, onChange == null ? afterVal : null, null));
            this.doChange(after, before, onChange);
        }
    }

    public <T> void sendList(@Nullable List<T> after, @Nullable List<T> before, Function<T, ?> id, @Nullable Consumer<T> onChange) {
        this.send(after, before, () -> {
            assert (after != null) : "A DELETE event should have been sent.";
            Map<Object, Integer> beforeIdx = this.putListPositions(after, before, id);
            for (Object anAfter : after) {
                Object aBefore;
                Runnable onChangeRun;
                Integer beforePos = beforeIdx.get(id.apply(anAfter));
                Runnable runnable = onChangeRun = onChange == null ? null : () -> onChange.accept(anAfter);
                if (beforePos == null) {
                    this.add(anAfter, onChangeRun);
                    continue;
                }
                Object v1 = aBefore = before == null ? null : before.get(beforePos);
                if (aBefore == anAfter) {
                    this.put(new RpcObjectData(RpcObjectData.State.NO_CHANGE, null, null, null));
                    continue;
                }
                this.put(new RpcObjectData(RpcObjectData.State.CHANGE, null, null, null));
                this.doChange(anAfter, aBefore, onChangeRun);
            }
        });
    }

    private <T> Map<Object, Integer> putListPositions(List<T> after, @Nullable List<T> before, Function<T, ?> id) {
        IdentityHashMap<Object, Integer> beforeIdx = new IdentityHashMap<Object, Integer>();
        if (before != null) {
            for (int i = 0; i < before.size(); ++i) {
                beforeIdx.put(id.apply(before.get(i)), i);
            }
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (T t : after) {
            Integer beforePos = (Integer)beforeIdx.get(id.apply(t));
            positions.add(beforePos == null ? -1 : beforePos);
        }
        this.put(new RpcObjectData(RpcObjectData.State.CHANGE, null, positions, null));
        return beforeIdx;
    }

    private void add(@Nullable Object after, @Nullable Runnable onChange) {
        Object afterVal = Reference.getValue(after);
        Integer ref = null;
        if (afterVal != null && after != afterVal) {
            if (this.refs.containsKey(afterVal)) {
                this.put(new RpcObjectData(RpcObjectData.State.ADD, RpcSendQueue.getValueType(afterVal), null, this.refs.get(afterVal)));
                return;
            }
            ref = this.refs.size() + 1;
            this.refs.put(afterVal, ref);
        }
        this.put(new RpcObjectData(RpcObjectData.State.ADD, RpcSendQueue.getValueType(afterVal), onChange == null ? afterVal : null, ref));
        this.doChange(afterVal, null, onChange);
    }

    private void doChange(@Nullable Object after, @Nullable Object before, @Nullable Runnable onChange) {
        if (onChange != null) {
            Object lastBefore = this.before;
            this.before = before;
            if (after != null) {
                onChange.run();
            }
            this.before = lastBefore;
        }
    }

    private static @Nullable String getValueType(@Nullable Object after) {
        if (after == null) {
            return null;
        }
        Class<?> type = after.getClass();
        if (type.isPrimitive() || type.getPackage().getName().startsWith("java.lang") || type.equals(UUID.class) || Iterable.class.isAssignableFrom(type)) {
            return null;
        }
        return type.getName();
    }
}

