/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.service;

import java.util.regex.Pattern;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.NamingService;

public class CSharpNamingService
implements NamingService {
    private static final Pattern STANDARD_METHOD_NAME = Pattern.compile("^[A-Z][a-zA-Z0-9]*$");
    private static final Pattern SNAKE_CASE = Pattern.compile("^[a-zA-Z0-9]+_\\w+$");

    public String standardizeMethodName(String oldMethodName) {
        if (!STANDARD_METHOD_NAME.matcher(oldMethodName).matches()) {
            StringBuilder result = new StringBuilder();
            if (SNAKE_CASE.matcher(oldMethodName).matches()) {
                result.append(NameCaseConvention.format((NameCaseConvention)NameCaseConvention.UPPER_CAMEL, (String)oldMethodName));
            } else {
                int nameLength = oldMethodName.length();
                for (int i = 0; i < nameLength; ++i) {
                    char c = oldMethodName.charAt(i);
                    if (i == 0) {
                        if (c == '$' || c == '_') continue;
                        result.append(Character.toUpperCase(c));
                        continue;
                    }
                    if (!Character.isLetterOrDigit(c)) {
                        while (!(Character.isLetterOrDigit(c) && c <= 'z' || ++i >= nameLength)) {
                            c = oldMethodName.charAt(i);
                        }
                        if (i >= nameLength) continue;
                        result.append(Character.toUpperCase(c));
                        continue;
                    }
                    result.append(c);
                }
            }
            return result.toString();
        }
        return oldMethodName;
    }
}

