/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.binary.Binary;
import org.openrewrite.binary.BinaryParser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.text.PlainText;

public final class AddGradleWrapper
extends Recipe {
    private static final String DEFAULT_VERSION = "7.4.2";
    private static final String DEFAULT_DISTRIBUTION = "bin";
    private static final Path WRAPPER_JAR_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.jar", new String[0]);
    private static final Path WRAPPER_PROPERTIES_LOCATION = Paths.get("gradle/wrapper/gradle-wrapper.properties", new String[0]);
    private static final Path WRAPPER_SCRIPT_LOCATION = Paths.get("gradlew", new String[0]);
    private static final Path WRAPPER_BATCH_LOCATION = Paths.get("gradlew.bat", new String[0]);
    @Option(displayName="Version", description="The version of Gradle to use. Defaults to 7.4.2", example="7.4.2", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. Defaults to \"bin\".", example="bin", required=false)
    @Nullable
    private final String distribution;
    @Option(displayName="Distribution Url", description="The URL to download the Gradle distribution from. Providing the distribution url overrides the \"Version\" and \"Distribution type\" parameters. This is intended to cover customized distributions of the Gradle wrapper.", example="https://services.gradle.org/distributions/gradle-7.4.2-bin.zip", required=false)
    @Nullable
    private final String distributionUrl;

    public String getDisplayName() {
        return "Add Gradle wrapper";
    }

    public String getDescription() {
        return "Add a Gradle wrapper where one does not exist.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        boolean needsGradleWrapperProperties = true;
        boolean needsGradleShellScript = true;
        boolean needsGradleBatchScript = true;
        for (SourceFile sourceFile : before) {
            if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)WRAPPER_PROPERTIES_LOCATION)) {
                needsGradleWrapperProperties = false;
                continue;
            }
            if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)WRAPPER_SCRIPT_LOCATION)) {
                needsGradleShellScript = false;
                continue;
            }
            if (!PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)WRAPPER_BATCH_LOCATION)) continue;
            needsGradleBatchScript = false;
        }
        ArrayList<Object> gradleWrapper = new ArrayList<Object>();
        if (needsGradleWrapperProperties) {
            Properties.File gradleWrapperProperties = ((Properties.File)new PropertiesParser().parse(new String[]{"distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + this.getDesiredDistributionUrl() + "\nzipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists"}).get(0)).withSourcePath(WRAPPER_PROPERTIES_LOCATION);
            gradleWrapper.add(gradleWrapperProperties);
        }
        if (needsGradleShellScript) {
            PlainText gradlew = new PlainText(Tree.randomId(), WRAPPER_SCRIPT_LOCATION, null, false, Markers.EMPTY, StringUtils.readFully((InputStream)AddGradleWrapper.class.getResourceAsStream("/gradlew")));
            gradleWrapper.add(gradlew);
        }
        if (needsGradleBatchScript) {
            PlainText gradlewBat = new PlainText(Tree.randomId(), WRAPPER_BATCH_LOCATION, null, false, Markers.EMPTY, StringUtils.readFully((InputStream)AddGradleWrapper.class.getResourceAsStream("/gradlew.bat")));
            gradleWrapper.add(gradlewBat);
        }
        if (needsGradleWrapperProperties || needsGradleShellScript || needsGradleBatchScript) {
            Binary gradleWrapperJar = (Binary)new BinaryParser().parseInputs(Collections.singletonList(new Parser.Input(WRAPPER_JAR_LOCATION, () -> AddGradleWrapper.class.getResourceAsStream("/gradle-wrapper.jar.dontunpack"))), null, ctx).get(0);
            gradleWrapper.add(gradleWrapperJar);
        }
        return ListUtils.concatAll(before, gradleWrapper);
    }

    private String getDesiredDistributionUrl() {
        if (this.distributionUrl != null) {
            return this.distributionUrl.replaceAll("(?<!\\\\)://", "\\\\://");
        }
        String desiredVersion = this.version == null ? DEFAULT_VERSION : this.version;
        String desiredDistribution = this.distribution == null ? DEFAULT_DISTRIBUTION : this.distribution;
        return "https\\://services.gradle.org/distributions/gradle-" + desiredVersion + "-" + desiredDistribution + ".zip";
    }

    public AddGradleWrapper(@Nullable String version, @Nullable String distribution, @Nullable String distributionUrl) {
        this.version = version;
        this.distribution = distribution;
        this.distributionUrl = distributionUrl;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getDistribution() {
        return this.distribution;
    }

    @Nullable
    public String getDistributionUrl() {
        return this.distributionUrl;
    }

    @NonNull
    public String toString() {
        return "AddGradleWrapper(version=" + this.getVersion() + ", distribution=" + this.getDistribution() + ", distributionUrl=" + this.getDistributionUrl() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddGradleWrapper)) {
            return false;
        }
        AddGradleWrapper other = (AddGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        String this$distributionUrl = this.getDistributionUrl();
        String other$distributionUrl = other.getDistributionUrl();
        return !(this$distributionUrl == null ? other$distributionUrl != null : !this$distributionUrl.equals(other$distributionUrl));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddGradleWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        String $distributionUrl = this.getDistributionUrl();
        result = result * 59 + ($distributionUrl == null ? 43 : $distributionUrl.hashCode());
        return result;
    }
}

