/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.plugins.AddPluginVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.Semver;

public final class AddSettingsPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to apply.", example="com.jfrog.bintray")
    private final String pluginId;
    @Option(displayName="Plugin version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors). Defaults to `latest.release`.", example="3.x", required=false)
    @Nullable
    private final String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Add Gradle settings plugin";
    }

    public String getDescription() {
        return "Add plugin to Gradle settings file `plugins` block by id.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new AddPluginVisitor(this.pluginId, StringUtils.isBlank((String)this.version) ? "latest.release" : this.version, this.versionPattern));
    }

    public AddSettingsPlugin(String pluginId, @Nullable String version, @Nullable String versionPattern) {
        this.pluginId = pluginId;
        this.version = version;
        this.versionPattern = versionPattern;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "AddSettingsPlugin(pluginId=" + this.getPluginId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddSettingsPlugin)) {
            return false;
        }
        AddSettingsPlugin other = (AddSettingsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddSettingsPlugin;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

