/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.marker;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.marker.FeaturePreview;
import org.openrewrite.gradle.marker.GradleBuildscript;
import org.openrewrite.gradle.marker.GradlePluginDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.tree.MavenRepository;

public final class GradleSettings
implements Marker,
Serializable {
    private final UUID id;
    @Deprecated
    private final @Nullable List<MavenRepository> pluginRepositories;
    private final List<GradlePluginDescriptor> plugins;
    private final Map<String, FeaturePreview> featurePreviews;
    private final GradleBuildscript buildscript;

    public GradleSettings(UUID id, List<MavenRepository> pluginRepositories, List<GradlePluginDescriptor> plugins, Map<String, FeaturePreview> featurePreviews) {
        this(id, pluginRepositories, plugins, featurePreviews, null);
    }

    public @Nullable Boolean isFeatureEnabled(String name) {
        return this.featurePreviews.get(name).getEnabled();
    }

    public Set<FeaturePreview> getActiveFeatures() {
        return this.featurePreviews.values().stream().filter(FeaturePreview::isActive).collect(Collectors.toSet());
    }

    @Deprecated
    public List<MavenRepository> getPluginRepositories() {
        if (this.buildscript != null) {
            return this.buildscript.getMavenRepositories();
        }
        return this.pluginRepositories == null ? Collections.emptyList() : this.pluginRepositories;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public List<GradlePluginDescriptor> getPlugins() {
        return this.plugins;
    }

    @Generated
    public Map<String, FeaturePreview> getFeaturePreviews() {
        return this.featurePreviews;
    }

    @Generated
    public GradleBuildscript getBuildscript() {
        return this.buildscript;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleSettings)) {
            return false;
        }
        GradleSettings other = (GradleSettings)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<MavenRepository> this$pluginRepositories = this.getPluginRepositories();
        List<MavenRepository> other$pluginRepositories = other.getPluginRepositories();
        if (this$pluginRepositories == null ? other$pluginRepositories != null : !((Object)this$pluginRepositories).equals(other$pluginRepositories)) {
            return false;
        }
        List<GradlePluginDescriptor> this$plugins = this.getPlugins();
        List<GradlePluginDescriptor> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        Map<String, FeaturePreview> this$featurePreviews = this.getFeaturePreviews();
        Map<String, FeaturePreview> other$featurePreviews = other.getFeaturePreviews();
        if (this$featurePreviews == null ? other$featurePreviews != null : !((Object)this$featurePreviews).equals(other$featurePreviews)) {
            return false;
        }
        GradleBuildscript this$buildscript = this.getBuildscript();
        GradleBuildscript other$buildscript = other.getBuildscript();
        return !(this$buildscript == null ? other$buildscript != null : !((Object)this$buildscript).equals(other$buildscript));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<MavenRepository> $pluginRepositories = this.getPluginRepositories();
        result = result * 59 + ($pluginRepositories == null ? 43 : ((Object)$pluginRepositories).hashCode());
        List<GradlePluginDescriptor> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        Map<String, FeaturePreview> $featurePreviews = this.getFeaturePreviews();
        result = result * 59 + ($featurePreviews == null ? 43 : ((Object)$featurePreviews).hashCode());
        GradleBuildscript $buildscript = this.getBuildscript();
        result = result * 59 + ($buildscript == null ? 43 : ((Object)$buildscript).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleSettings(id=" + this.getId() + ", pluginRepositories=" + this.getPluginRepositories() + ", plugins=" + this.getPlugins() + ", featurePreviews=" + this.getFeaturePreviews() + ", buildscript=" + this.getBuildscript() + ")";
    }

    @NonNull
    @Generated
    public GradleSettings withId(UUID id) {
        return this.id == id ? this : new GradleSettings(id, this.pluginRepositories, this.plugins, this.featurePreviews, this.buildscript);
    }

    @NonNull
    @Deprecated
    @Generated
    public GradleSettings withPluginRepositories(@Nullable List<MavenRepository> pluginRepositories) {
        return this.pluginRepositories == pluginRepositories ? this : new GradleSettings(this.id, pluginRepositories, this.plugins, this.featurePreviews, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleSettings withPlugins(List<GradlePluginDescriptor> plugins) {
        return this.plugins == plugins ? this : new GradleSettings(this.id, this.pluginRepositories, plugins, this.featurePreviews, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleSettings withFeaturePreviews(Map<String, FeaturePreview> featurePreviews) {
        return this.featurePreviews == featurePreviews ? this : new GradleSettings(this.id, this.pluginRepositories, this.plugins, featurePreviews, this.buildscript);
    }

    @NonNull
    @Generated
    public GradleSettings withBuildscript(GradleBuildscript buildscript) {
        return this.buildscript == buildscript ? this : new GradleSettings(this.id, this.pluginRepositories, this.plugins, this.featurePreviews, buildscript);
    }

    @JsonCreator
    @Generated
    public GradleSettings(UUID id, @Nullable List<MavenRepository> pluginRepositories, List<GradlePluginDescriptor> plugins, Map<String, FeaturePreview> featurePreviews, GradleBuildscript buildscript) {
        this.id = id;
        this.pluginRepositories = pluginRepositories;
        this.plugins = plugins;
        this.featurePreviews = featurePreviews;
        this.buildscript = buildscript;
    }
}

