/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestPatch;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

@Incubating(since="8.17.0")
public final class DependencyVersionSelector {
    private final @Nullable MavenMetadataFailures metadataFailures;
    private final @Nullable GradleProject gradleProject;
    private final @Nullable GradleSettings gradleSettings;

    public @Nullable String select(GroupArtifact ga, String configuration, @Nullable String version, @Nullable String versionPattern, ExecutionContext ctx) throws MavenDownloadingException {
        Dependency requested;
        GradleDependencyConfiguration gdc;
        String currentVersion = "0";
        if (this.gradleProject != null && (gdc = this.gradleProject.getConfiguration(configuration)) != null && (requested = gdc.findRequestedDependency(ga.getGroupId(), ga.getArtifactId())) != null && requested.getVersion() != null) {
            currentVersion = requested.getVersion();
        }
        return this.select(new GroupArtifactVersion(ga.getGroupId(), ga.getArtifactId(), currentVersion), configuration, "latest.patch".equalsIgnoreCase(version) && "0".equals(currentVersion) ? "latest.release" : version, versionPattern, ctx);
    }

    public @Nullable String select(ResolvedGroupArtifactVersion gav, String configuration, @Nullable String version, @Nullable String versionPattern, ExecutionContext ctx) throws MavenDownloadingException {
        return this.select(new GroupArtifactVersion(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()), configuration, version, versionPattern, ctx);
    }

    public @Nullable String select(GroupArtifactVersion gav, @Nullable String configuration, @Nullable String version, @Nullable String versionPattern, ExecutionContext ctx) throws MavenDownloadingException {
        if (gav.getVersion() == null) {
            throw new IllegalArgumentException("Version must be specified. Call the select method that accepts a GroupArtifact instead if there is no current version.");
        }
        try {
            LatestRelease versionComparator;
            Object object = versionComparator = StringUtils.isBlank((String)version) ? new LatestRelease(versionPattern) : Objects.requireNonNull((VersionComparator)Semver.validate((String)version, (String)versionPattern).getValue());
            if (versionComparator instanceof ExactVersion) {
                return versionComparator.upgrade(gav.getVersion(), Collections.singletonList(version)).orElse(null);
            }
            if (versionComparator instanceof LatestPatch && !Semver.isVersion((String)gav.getVersion())) {
                return null;
            }
            return this.findNewerVersion(gav, configuration, (VersionComparator)versionComparator, ctx).orElse(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private Optional<String> findNewerVersion(GroupArtifactVersion gav, @Nullable String configuration, VersionComparator versionComparator, ExecutionContext ctx) throws MavenDownloadingException {
        try {
            if (gav.getGroupId() == null) {
                return Optional.empty();
            }
            List<MavenRepository> repos = this.determineRepos(configuration);
            MavenMetadata mavenMetadata = this.metadataFailures == null ? this.downloadMetadata(gav.getGroupId(), gav.getArtifactId(), repos, ctx) : this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(gav.getGroupId(), gav.getArtifactId(), repos, ctx));
            return versionComparator.upgrade(Objects.requireNonNull(gav.getVersion()), (Collection)mavenMetadata.getVersioning().getVersions());
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    private MavenMetadata downloadMetadata(String groupId, String artifactId, List<MavenRepository> repositories, ExecutionContext ctx) throws MavenDownloadingException {
        return new MavenPomDownloader(ctx).downloadMetadata(new GroupArtifact(groupId, artifactId), null, repositories);
    }

    private List<MavenRepository> determineRepos(@Nullable String configuration) {
        if (this.gradleSettings != null) {
            return this.gradleSettings.getBuildscript().getMavenRepositories();
        }
        if (this.gradleProject == null) {
            throw new IllegalStateException("Gradle project must be set to determine repositories.");
        }
        return "classpath".equals(configuration) ? this.gradleProject.getBuildscript().getMavenRepositories() : this.gradleProject.getMavenRepositories();
    }

    @Generated
    public DependencyVersionSelector(@Nullable MavenMetadataFailures metadataFailures, @Nullable GradleProject gradleProject, @Nullable GradleSettings gradleSettings) {
        this.metadataFailures = metadataFailures;
        this.gradleProject = gradleProject;
        this.gradleSettings = gradleSettings;
    }

    @Generated
    public @Nullable MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public @Nullable GradleProject getGradleProject() {
        return this.gradleProject;
    }

    @Generated
    public @Nullable GradleSettings getGradleSettings() {
        return this.gradleSettings;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyVersionSelector)) {
            return false;
        }
        DependencyVersionSelector other = (DependencyVersionSelector)o;
        MavenMetadataFailures this$metadataFailures = this.getMetadataFailures();
        MavenMetadataFailures other$metadataFailures = other.getMetadataFailures();
        if (this$metadataFailures == null ? other$metadataFailures != null : !this$metadataFailures.equals(other$metadataFailures)) {
            return false;
        }
        GradleProject this$gradleProject = this.getGradleProject();
        GradleProject other$gradleProject = other.getGradleProject();
        if (this$gradleProject == null ? other$gradleProject != null : !((Object)this$gradleProject).equals(other$gradleProject)) {
            return false;
        }
        GradleSettings this$gradleSettings = this.getGradleSettings();
        GradleSettings other$gradleSettings = other.getGradleSettings();
        return !(this$gradleSettings == null ? other$gradleSettings != null : !((Object)this$gradleSettings).equals(other$gradleSettings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MavenMetadataFailures $metadataFailures = this.getMetadataFailures();
        result = result * 59 + ($metadataFailures == null ? 43 : $metadataFailures.hashCode());
        GradleProject $gradleProject = this.getGradleProject();
        result = result * 59 + ($gradleProject == null ? 43 : ((Object)$gradleProject).hashCode());
        GradleSettings $gradleSettings = this.getGradleSettings();
        result = result * 59 + ($gradleSettings == null ? 43 : ((Object)$gradleSettings).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyVersionSelector(metadataFailures=" + this.getMetadataFailures() + ", gradleProject=" + this.getGradleProject() + ", gradleSettings=" + this.getGradleSettings() + ")";
    }
}

