/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.gradle.internal.DefaultImportsCustomizer;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.JavaParser;
import org.openrewrite.kotlin.KotlinParser;

public class GradleParser
implements Parser {
    private final Builder base;
    private @Nullable List<Path> defaultClasspath;
    private @Nullable GroovyParser groovyBuildParser;
    private @Nullable GroovyParser groovySettingsParser;
    private @Nullable KotlinParser kotlinBuildParser;
    private @Nullable KotlinParser kotlinSettingsParser;

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        Collection<Path> settingsClasspath;
        Collection<Path> buildscriptClasspath;
        if (this.groovyBuildParser == null) {
            buildscriptClasspath = this.base.buildscriptClasspath;
            if (buildscriptClasspath == null) {
                buildscriptClasspath = this.defaultClasspath(ctx);
            }
            this.groovyBuildParser = GroovyParser.builder((GroovyParser.Builder)this.base.groovyParser).classpath(buildscriptClasspath).compilerCustomizers(new Consumer[]{new DefaultImportsCustomizer(), config -> config.setScriptBaseClass("RewriteGradleProject")}).build();
        }
        if (this.kotlinBuildParser == null) {
            buildscriptClasspath = this.base.buildscriptClasspath;
            if (buildscriptClasspath == null) {
                buildscriptClasspath = this.defaultClasspath(ctx);
            }
            this.kotlinBuildParser = KotlinParser.builder((KotlinParser.Builder)this.base.kotlinParser).classpath(buildscriptClasspath).build();
        }
        if (this.groovySettingsParser == null) {
            settingsClasspath = this.base.settingsClasspath;
            if (settingsClasspath == null) {
                settingsClasspath = this.defaultClasspath(ctx);
            }
            this.groovySettingsParser = GroovyParser.builder((GroovyParser.Builder)this.base.groovyParser).classpath(settingsClasspath).compilerCustomizers(new Consumer[]{new DefaultImportsCustomizer(), config -> config.setScriptBaseClass("RewriteSettings")}).build();
        }
        if (this.kotlinSettingsParser == null) {
            settingsClasspath = this.base.settingsClasspath;
            if (settingsClasspath == null) {
                settingsClasspath = this.defaultClasspath(ctx);
            }
            this.kotlinSettingsParser = KotlinParser.builder((KotlinParser.Builder)this.base.kotlinParser).classpath(settingsClasspath).build();
        }
        return StreamSupport.stream(sources.spliterator(), false).flatMap(source -> {
            Path sourcePath = source.getPath();
            if (sourcePath.endsWith("settings.gradle.kts")) {
                return this.kotlinSettingsParser.parseInputs(Collections.singletonList(source), relativeTo, ctx);
            }
            if (sourcePath.endsWith("settings.gradle")) {
                return this.groovySettingsParser.parseInputs(Collections.singletonList(source), relativeTo, ctx);
            }
            if (sourcePath.toString().endsWith(".gradle.kts")) {
                return this.kotlinBuildParser.parseInputs(Collections.singletonList(source), relativeTo, ctx);
            }
            return this.groovyBuildParser.parseInputs(Collections.singletonList(source), relativeTo, ctx);
        });
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".gradle") || path.toString().endsWith(".gradle.kts");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("build.gradle");
    }

    public static Builder builder() {
        return new Builder();
    }

    private List<Path> defaultClasspath(ExecutionContext ctx) {
        if (this.defaultClasspath == null) {
            try {
                Class.forName("org.gradle.api.Project");
                this.defaultClasspath = JavaParser.runtimeClasspath();
            }
            catch (ClassNotFoundException e) {
                this.defaultClasspath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])new String[]{"gradle-base-services", "gradle-core-api", "gradle-language-groovy", "gradle-language-java", "gradle-logging", "gradle-messaging", "gradle-native", "gradle-process-services", "gradle-resources", "gradle-testing-base", "gradle-testing-jvm", "develocity-gradle-plugin"});
            }
        }
        return this.defaultClasspath;
    }

    @Generated
    public GradleParser(Builder base) {
        this.base = base;
    }

    public static class Builder
    extends Parser.Builder {
        protected GroovyParser.Builder groovyParser = GroovyParser.builder();
        protected KotlinParser.Builder kotlinParser = KotlinParser.builder();
        private @Nullable Collection<Path> buildscriptClasspath;
        private @Nullable Collection<Path> settingsClasspath;

        public Builder() {
            super(G.CompilationUnit.class);
        }

        public Builder groovyParser(GroovyParser.Builder groovyParser) {
            this.groovyParser = groovyParser;
            return this;
        }

        public Builder kotlinParser(KotlinParser.Builder kotlinParser) {
            this.kotlinParser = kotlinParser;
            return this;
        }

        public Builder buildscriptClasspath(Collection<Path> classpath) {
            this.buildscriptClasspath = classpath;
            return this;
        }

        public Builder buildscriptClasspath(String ... classpath) {
            this.buildscriptClasspath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder buildscriptClasspathFromResources(ExecutionContext ctx, String ... artifactNamesWithVersions) {
            this.buildscriptClasspath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])artifactNamesWithVersions);
            return this;
        }

        public Builder settingsClasspath(Collection<Path> classpath) {
            this.settingsClasspath = classpath;
            return this;
        }

        public Builder settingsClasspath(String ... classpath) {
            this.settingsClasspath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder settingsClasspathFromResources(ExecutionContext ctx, String ... artifactNamesWithVersions) {
            this.settingsClasspath = JavaParser.dependenciesFromResources((ExecutionContext)ctx, (String[])artifactNamesWithVersions);
            return this;
        }

        public GradleParser build() {
            return new GradleParser(this);
        }

        public String getDslName() {
            return "gradle";
        }
    }
}

