/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class BooleanChecksNotInverted
extends Recipe {
    public String getDisplayName() {
        return "Boolean checks should not be inverted";
    }

    public String getDescription() {
        return "It is needlessly complex to invert the result of a boolean comparison. The opposite comparison should be made instead.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1940");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J.Parentheses expr;
                if (unary.getOperator() == J.Unary.Type.Not && unary.getExpression() instanceof J.Parentheses && (expr = (J.Parentheses)unary.getExpression()).getTree() instanceof J.Binary) {
                    J.Binary binary = (J.Binary)expr.getTree();
                    switch (binary.getOperator()) {
                        case LessThan: {
                            return ((J)super.visit((Tree)binary.withOperator(J.Binary.Type.GreaterThanOrEqual), (Object)ctx)).withPrefix(unary.getPrefix());
                        }
                        case GreaterThan: {
                            return ((J)super.visit((Tree)binary.withOperator(J.Binary.Type.LessThanOrEqual), (Object)ctx)).withPrefix(unary.getPrefix());
                        }
                        case LessThanOrEqual: {
                            return ((J)super.visit((Tree)binary.withOperator(J.Binary.Type.GreaterThan), (Object)ctx)).withPrefix(unary.getPrefix());
                        }
                        case GreaterThanOrEqual: {
                            return ((J)super.visit((Tree)binary.withOperator(J.Binary.Type.LessThan), (Object)ctx)).withPrefix(unary.getPrefix());
                        }
                        case Equal: {
                            return ((J)super.visit((Tree)binary.withOperator(J.Binary.Type.NotEqual), (Object)ctx)).withPrefix(unary.getPrefix());
                        }
                        case NotEqual: {
                            return ((J)super.visit((Tree)binary.withOperator(J.Binary.Type.Equal), (Object)ctx)).withPrefix(unary.getPrefix());
                        }
                    }
                }
                return super.visitUnary(unary, ctx);
            }
        };
    }
}

