/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.HideUtilityClassConstructorStyle;
import org.openrewrite.java.tree.JavaSourceFile;

@Incubating(since="7.0.0")
public class HideUtilityClassConstructor
extends Recipe {
    public String getDisplayName() {
        return "Hide utility class constructor";
    }

    public String getDescription() {
        return "Ensures utility classes (classes containing only static methods or fields in their API) do not have a public constructor.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1118");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HideUtilityClassConstructorFromCompilationUnitStyle();
    }

    private static class HideUtilityClassConstructorFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private HideUtilityClassConstructorFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            HideUtilityClassConstructorStyle style = (HideUtilityClassConstructorStyle)((SourceFile)cu).getStyle(HideUtilityClassConstructorStyle.class);
            if (style == null) {
                style = Checkstyle.hideUtilityClassConstructorStyle();
            }
            this.doAfterVisit(new HideUtilityClassConstructorVisitor(style));
            return cu;
        }
    }
}

