/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class MultipleVariableDeclarationsVisitor
extends JavaIsoVisitor<ExecutionContext> {
    @Override
    public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
        J b = super.visitBlock(block, ctx);
        boolean splitAtLeastOneVariable = false;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Statement stmt : ((J.Block)b).getStatements()) {
            if (stmt instanceof J.VariableDeclarations) {
                J.VariableDeclarations mv = (J.VariableDeclarations)stmt;
                if (mv.getVariables().size() > 1) {
                    splitAtLeastOneVariable = true;
                    for (int i = 0; i < mv.getVariables().size(); ++i) {
                        J.VariableDeclarations.NamedVariable nv = mv.getVariables().get(i);
                        List dimensions = ListUtils.concatAll(mv.getDimensionsBeforeName(), nv.getDimensionsAfterName());
                        nv = nv.withDimensionsAfterName(Collections.emptyList());
                        J.VariableDeclarations vd = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, mv.getLeadingAnnotations(), mv.getModifiers(), mv.getTypeExpression(), mv.getVarargs(), dimensions, Collections.singletonList(JRightPadded.build(nv)));
                        if (i == 0) {
                            vd = (J.VariableDeclarations)vd.withComments(mv.getComments()).withPrefix(mv.getPrefix());
                        }
                        vd = this.autoFormat(vd, ctx);
                        statements.add(vd);
                    }
                    continue;
                }
                statements.add(stmt);
                continue;
            }
            statements.add(stmt);
        }
        return splitAtLeastOneVariable ? ((J.Block)b).withStatements(statements) : b;
    }
}

