/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.tree.J;

public class RenameExceptionInEmptyCatch
extends Recipe {
    public String getDisplayName() {
        return "Rename caught exceptions in empty catch blocks to `ignored`";
    }

    public String getDescription() {
        return "Renames caught exceptions in empty catch blocks to `ignored`. `ignored` will be incremented by 1 if a namespace conflict exists.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                LinkedHashMap variableScopes = new LinkedHashMap();
                executionContext.putMessage("VARIABLES_KEY", variableScopes);
                return super.visitCompilationUnit(cu, executionContext);
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                Map variableScope = (Map)executionContext.getMessage("VARIABLES_KEY");
                if (variableScope != null) {
                    classDecl.getBody().getStatements().forEach(o -> {
                        if (o instanceof J.VariableDeclarations) {
                            J.VariableDeclarations variableDeclarations = (J.VariableDeclarations)o;
                            variableDeclarations.getVariables().forEach(v -> variableScope.computeIfAbsent(this.getCursor(), k -> new HashSet()).add(v.getSimpleName()));
                        }
                    });
                }
                return super.visitClassDeclaration(classDecl, executionContext);
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext executionContext) {
                Map variableScope;
                Cursor parentScope;
                if (this.validIdentifier() && !((parentScope = this.getCursorToParentScope()).getValue() instanceof J.ClassDeclaration) && (variableScope = (Map)executionContext.getMessage("VARIABLES_KEY")) != null) {
                    Set namesInScope = variableScope.computeIfAbsent(parentScope, k -> new HashSet());
                    namesInScope.add(identifier.getSimpleName());
                }
                return super.visitIdentifier(identifier, executionContext);
            }

            @Override
            public J.Try.Catch visitCatch(J.Try.Catch _catch, ExecutionContext executionContext) {
                if (_catch.getBody().getStatements().isEmpty() && _catch.getBody().getEnd().getComments().isEmpty()) {
                    return super.visitCatch(_catch, executionContext);
                }
                return _catch;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                Map variableScopes;
                Cursor parentScope = this.getCursorToParentScope();
                if (parentScope.getValue() instanceof J.Try.Catch && (variableScopes = (Map)executionContext.getMessage("VARIABLES_KEY")) != null) {
                    Set namesInScope = variableScopes.computeIfAbsent(parentScope, k -> new HashSet());
                    namesInScope.addAll(multiVariable.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getSimpleName).collect(Collectors.toList()));
                    this.aggregateNameScopes(variableScopes);
                    String baseName = "ignored";
                    int count = 0;
                    for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
                        if (variable.getSimpleName().contains(baseName)) continue;
                        String newName = baseName;
                        while (variableScopes.containsKey(parentScope) && ((Set)variableScopes.get(parentScope)).contains(newName)) {
                            newName = baseName + ++count;
                        }
                        this.doAfterVisit(new RenameVariable(variable, newName));
                        namesInScope.add(newName);
                    }
                }
                return super.visitVariableDeclarations(multiVariable, executionContext);
            }

            private void aggregateNameScopes(Map<Cursor, Set<String>> variableScopes) {
                ArrayList<Cursor> parentScopes = new ArrayList<Cursor>(variableScopes.keySet());
                parentScopes.forEach(parentScope -> {
                    for (Cursor maybeInScope : parentScopes) {
                        if (!parentScope.isScopeInPath((Tree)maybeInScope.getValue())) continue;
                        ((Set)variableScopes.get(parentScope)).addAll((Collection)variableScopes.get(maybeInScope));
                    }
                });
            }

            private boolean validIdentifier() {
                Cursor parent = this.getCursor().getParent();
                return parent != null && !(parent.getValue() instanceof J.ClassDeclaration) && !(parent.getValue() instanceof J.MethodDeclaration) && !(parent.getValue() instanceof J.MethodInvocation);
            }

            private Cursor getCursorToParentScope() {
                return this.getCursor().dropParentUntil(is -> is instanceof J.CompilationUnit || is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
            }
        };
    }
}

