/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class ReplaceLambdaWithMethodReference
extends Recipe {
    public String getDisplayName() {
        return "Use method references in lambda";
    }

    public String getDescription() {
        return "Replaces the single statement lambdas `o -> o instanceOf X`, `o -> (A) o`, `o -> System.out.println(o)`, `o -> o != null`, `o -> o == null` with the equivalent method reference.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1612");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher printStreamMethod = new MethodMatcher("java.io.PrintStream println(..)");
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
                TypeTree tree;
                J.ControlParentheses<TypeTree> j;
                J.Lambda l = (J.Lambda)super.visitLambda(lambda, executionContext);
                String code = "";
                J body = l.getBody();
                if (body instanceof J.Block && ((J.Block)body).getStatements().size() == 1) {
                    Statement statement = ((J.Block)body).getStatements().get(0);
                    if (statement instanceof J.MethodInvocation) {
                        body = statement;
                    }
                } else if (body instanceof J.InstanceOf) {
                    j = ((J.InstanceOf)body).getClazz();
                    if (j instanceof J.Identifier) {
                        body = j;
                        code = "#{}.class::isInstance";
                    }
                } else if (body instanceof J.TypeCast && (j = ((J.TypeCast)body).getClazz()) != null && (tree = j.getTree()) instanceof J.Identifier) {
                    body = tree;
                    code = "#{}.class::cast";
                }
                if (body instanceof J.Identifier) {
                    J.Identifier identifier = (J.Identifier)body;
                    JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified(identifier.getType());
                    String stub = fullyQualified == null ? "" : "package " + fullyQualified.getPackageName() + "; public class " + fullyQualified.getClassName() + "{}";
                    JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), code).javaParser(() -> ((JavaParser.Builder)JavaParser.fromJavaVersion().dependsOn(stub)).build()).imports(fullyQualified == null ? "" : fullyQualified.getFullyQualifiedName()).build();
                    return l.withTemplate(template, l.getCoordinates().replace(), identifier.getSimpleName());
                }
                if (body instanceof J.Binary) {
                    J.Binary binary = (J.Binary)body;
                    if (this.isNullCheck(binary.getLeft(), binary.getRight()) || this.isNullCheck(binary.getRight(), binary.getLeft())) {
                        this.maybeAddImport("java.util.Objects");
                        code = J.Binary.Type.Equal.equals((Object)binary.getOperator()) ? "Objects::isNull" : "Objects::nonNull";
                        return l.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), code).imports("java.util.Objects").build(), l.getCoordinates().replace(), new Object[0]);
                    }
                } else if (body instanceof J.MethodInvocation && printStreamMethod.matches((J.MethodInvocation)body)) {
                    return l.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), "System.out::println").build(), l.getCoordinates().replace(), new Object[0]);
                }
                return l;
            }

            private boolean isNullCheck(J j1, J j2) {
                return j1 instanceof J.Identifier && j2 instanceof J.Literal && "null".equals(((J.Literal)j2).getValueSource());
            }
        };
    }
}

