/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import java.util.UUID;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public final class JavaVersion
implements Marker {
    private final UUID id;
    private final String createdBy;
    private final String vmVendor;
    private final String sourceCompatibility;
    private final String targetCompatibility;

    public int getMajorVersion() {
        try {
            return Integer.parseInt(this.normalize(this.sourceCompatibility));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String normalize(String version) {
        if (!version.contains(".")) {
            return version;
        }
        if (version.startsWith("1.")) {
            String removePrefix = version.substring(version.indexOf(".") + 1);
            return removePrefix.substring(0, version.indexOf("."));
        }
        return version.substring(0, version.indexOf("."));
    }

    public JavaVersion(UUID id, String createdBy, String vmVendor, String sourceCompatibility, String targetCompatibility) {
        this.id = id;
        this.createdBy = createdBy;
        this.vmVendor = vmVendor;
        this.sourceCompatibility = sourceCompatibility;
        this.targetCompatibility = targetCompatibility;
    }

    public UUID getId() {
        return this.id;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    @NonNull
    public String toString() {
        return "JavaVersion(id=" + this.getId() + ", createdBy=" + this.getCreatedBy() + ", vmVendor=" + this.getVmVendor() + ", sourceCompatibility=" + this.getSourceCompatibility() + ", targetCompatibility=" + this.getTargetCompatibility() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion other = (JavaVersion)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    public JavaVersion withId(UUID id) {
        return this.id == id ? this : new JavaVersion(id, this.createdBy, this.vmVendor, this.sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    public JavaVersion withCreatedBy(String createdBy) {
        return this.createdBy == createdBy ? this : new JavaVersion(this.id, createdBy, this.vmVendor, this.sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    public JavaVersion withVmVendor(String vmVendor) {
        return this.vmVendor == vmVendor ? this : new JavaVersion(this.id, this.createdBy, vmVendor, this.sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    public JavaVersion withSourceCompatibility(String sourceCompatibility) {
        return this.sourceCompatibility == sourceCompatibility ? this : new JavaVersion(this.id, this.createdBy, this.vmVendor, sourceCompatibility, this.targetCompatibility);
    }

    @NonNull
    public JavaVersion withTargetCompatibility(String targetCompatibility) {
        return this.targetCompatibility == targetCompatibility ? this : new JavaVersion(this.id, this.createdBy, this.vmVendor, this.sourceCompatibility, targetCompatibility);
    }
}

