/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Optional;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.JavaSourceFile;

public class UsesJavaVersion<P>
extends JavaIsoVisitor<P> {
    int majorVersionMin;
    int majorVersionMax;

    public UsesJavaVersion(int majorVersion) {
        this.majorVersionMin = majorVersion;
        this.majorVersionMax = Integer.MAX_VALUE;
    }

    public UsesJavaVersion(int majorVersionMin, int majorVersionMax) {
        this.majorVersionMin = majorVersionMin;
        this.majorVersionMax = majorVersionMax;
    }

    @Override
    public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, P p) {
        Optional javaVersion = cu.getMarkers().findFirst(JavaVersion.class);
        if (javaVersion.isPresent() && this.isVersionInRange(((JavaVersion)javaVersion.get()).getMajorVersion())) {
            return (JavaSourceFile)cu.withMarkers(cu.getMarkers().searchResult());
        }
        return cu;
    }

    private boolean isVersionInRange(int majorVersion) {
        return this.majorVersionMin > 0 && this.majorVersionMin <= majorVersion && majorVersion <= this.majorVersionMax;
    }
}

