/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Locale;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.HasSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

@Incubating(since="7.36.0")
public class IsLikelyTest
extends Recipe {
    public String getDisplayName() {
        return "Find sources that are likely tests";
    }

    public String getDescription() {
        return "Sources that contain indicators of being, or being exclusively for the use in tests. This recipe is not exhaustive, but is intended to be a good starting point for finding test sources. Looks at the source set name, and types in use; for example looks for uses of JUnit & TestNG annotations/assertions.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return Applicability.or((TreeVisitor[])new TreeVisitor[]{new HasSourceSet("test").getVisitor(), new HasSourceSetNameContainingTestVisitor(), new UsesType("org.junit..*"), new UsesType("org.testng..*"), new UsesType("org.hamcrest..*"), new UsesType("org.mockito..*"), new UsesType("org.powermock..*"), new UsesType("org.assertj..*"), new UsesType("spock.lang..*")});
    }

    private static class HasSourceSetNameContainingTestVisitor<P>
    extends JavaIsoVisitor<P> {
        private HasSourceSetNameContainingTestVisitor() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, P p) {
            if (cu.getMarkers().findFirst(JavaSourceSet.class).filter(s -> s.getName().toLowerCase(Locale.ROOT).contains("test")).isPresent()) {
                return (JavaSourceFile)SearchResult.found((Tree)cu);
            }
            return cu;
        }
    }
}

