/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class FinalizeMethodArguments
extends Recipe {
    public String getDisplayName() {
        return "Finalize method arguments";
    }

    public String getDescription() {
        return "Adds the `final` modifier keyword to method parameters.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext executionContext) {
                J declarations = super.visitMethodDeclaration(methodDeclaration, executionContext);
                if (FinalizeMethodArguments.isWrongKind(methodDeclaration) || FinalizeMethodArguments.this.isEmpty(((J.MethodDeclaration)declarations).getParameters()) || FinalizeMethodArguments.this.hasFinalModifiers(((J.MethodDeclaration)declarations).getParameters()) || FinalizeMethodArguments.isAbstractMethod(methodDeclaration)) {
                    return declarations;
                }
                AtomicBoolean assigned = new AtomicBoolean(false);
                methodDeclaration.getParameters().forEach(p -> this.checkIfAssigned(assigned, (Statement)p));
                if (assigned.get()) {
                    return declarations;
                }
                List parameters = ListUtils.map(((J.MethodDeclaration)declarations).getParameters(), p -> FinalizeMethodArguments.updateParam(p));
                declarations = ((J.MethodDeclaration)declarations).withParameters(parameters);
                return declarations;
            }

            private void checkIfAssigned(AtomicBoolean assigned, Statement p) {
                J.VariableDeclarations variableDeclarations;
                if (p instanceof J.VariableDeclarations && (variableDeclarations = (J.VariableDeclarations)p).getVariables().stream().anyMatch(namedVariable -> FindAssignmentReferencesToVariable.find((J)this.getCursor().getParentTreeCursor().getValue(), namedVariable).get())) {
                    assigned.set(true);
                }
            }

            @Override
            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext executionContext) {
                return sourceFile instanceof JavaSourceFile;
            }
        };
    }

    private static boolean isWrongKind(J.MethodDeclaration methodDeclaration) {
        return Optional.ofNullable(methodDeclaration.getMethodType()).map(JavaType.Method::getDeclaringType).map(JavaType.FullyQualified::getKind).filter(JavaType.FullyQualified.Kind.Interface::equals).isPresent();
    }

    private static boolean isAbstractMethod(J.MethodDeclaration method) {
        return method.getModifiers().stream().anyMatch(modifier -> modifier.getType() == J.Modifier.Type.Abstract);
    }

    private static Statement updateParam(Statement p) {
        J.VariableDeclarations variableDeclarations;
        if (p instanceof J.VariableDeclarations && (variableDeclarations = (J.VariableDeclarations)p).getModifiers().isEmpty()) {
            variableDeclarations = FinalizeMethodArguments.updateModifiers(variableDeclarations, !((J.VariableDeclarations)p).getLeadingAnnotations().isEmpty());
            variableDeclarations = FinalizeMethodArguments.updateDeclarations(variableDeclarations);
            return variableDeclarations;
        }
        return p;
    }

    private static J.VariableDeclarations updateDeclarations(J.VariableDeclarations variableDeclarations) {
        return variableDeclarations.withTypeExpression(variableDeclarations.getTypeExpression() != null ? (TypeTree)variableDeclarations.getTypeExpression().withPrefix(Space.SINGLE_SPACE) : null);
    }

    private static J.VariableDeclarations updateModifiers(J.VariableDeclarations variableDeclarations, boolean leadingAnnotations) {
        List<J.Modifier> modifiers = variableDeclarations.getModifiers();
        J.Modifier finalModifier = new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList());
        if (leadingAnnotations) {
            finalModifier = finalModifier.withPrefix(Space.SINGLE_SPACE);
        }
        return variableDeclarations.withModifiers(ListUtils.concat((Object)finalModifier, modifiers));
    }

    private boolean hasFinalModifiers(List<Statement> parameters) {
        return parameters.stream().allMatch(p -> {
            if (p instanceof J.VariableDeclarations) {
                List<J.Modifier> modifiers = ((J.VariableDeclarations)p).getModifiers();
                return !modifiers.isEmpty() && modifiers.stream().allMatch(m -> m.getType().equals((Object)J.Modifier.Type.Final));
            }
            return false;
        });
    }

    private boolean isEmpty(List<Statement> parameters) {
        return parameters.size() == 1 && parameters.get(0) instanceof J.Empty;
    }

    private static final class FindAssignmentReferencesToVariable
    extends JavaIsoVisitor<AtomicBoolean> {
        private final J.VariableDeclarations.NamedVariable variable;

        static AtomicBoolean find(J subtree, J.VariableDeclarations.NamedVariable variable) {
            return (AtomicBoolean)new FindAssignmentReferencesToVariable(variable).reduce(subtree, new AtomicBoolean());
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment a, AtomicBoolean hasAssignment) {
            J.Identifier identifier;
            if (hasAssignment.get()) {
                return a;
            }
            J assignment = super.visitAssignment(a, hasAssignment);
            if (((J.Assignment)assignment).getVariable() instanceof J.Identifier && (identifier = (J.Identifier)((J.Assignment)assignment).getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return assignment;
        }

        public FindAssignmentReferencesToVariable(J.VariableDeclarations.NamedVariable variable) {
            this.variable = variable;
        }

        public J.VariableDeclarations.NamedVariable getVariable() {
            return this.variable;
        }

        @NonNull
        public String toString() {
            return "FinalizeMethodArguments.FindAssignmentReferencesToVariable(variable=" + this.getVariable() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindAssignmentReferencesToVariable)) {
                return false;
            }
            FindAssignmentReferencesToVariable other = (FindAssignmentReferencesToVariable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            J.VariableDeclarations.NamedVariable this$variable = this.getVariable();
            J.VariableDeclarations.NamedVariable other$variable = other.getVariable();
            return !(this$variable == null ? other$variable != null : !((Object)this$variable).equals(other$variable));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FindAssignmentReferencesToVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            J.VariableDeclarations.NamedVariable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : ((Object)$variable).hashCode());
            return result;
        }
    }
}

