/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class HasTypeOnClasspathSourceSet<P>
extends JavaIsoVisitor<P> {
    private final String fullyQualifiedTypeName;

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            return cu.getMarkers().findFirst(JavaSourceSet.class).filter(sourceSet -> {
                for (JavaType.FullyQualified classpath : sourceSet.getClasspath()) {
                    if (!TypeUtils.isOfClassType(classpath, this.fullyQualifiedTypeName)) continue;
                    return false;
                }
                return true;
            }).map(sourceSet -> cu).orElse((JavaSourceFile)SearchResult.found((Tree)cu));
        }
        return (J)super.visit(tree, p);
    }

    public HasTypeOnClasspathSourceSet(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @NonNull
    public String toString() {
        return "HasTypeOnClasspathSourceSet(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasTypeOnClasspathSourceSet)) {
            return false;
        }
        HasTypeOnClasspathSourceSet other = (HasTypeOnClasspathSourceSet)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasTypeOnClasspathSourceSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }
}

