/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.RemoveAnnotationVisitor;

public final class RemoveAnnotation
extends Recipe {
    @Option(displayName="Annotation pattern", description="An annotation pattern, expressed as a method pattern.", example="@java.lang.SuppressWarnings(\"deprecation\")")
    private final String annotationPattern;

    public String getDisplayName() {
        return "Remove annotation";
    }

    public String getDescription() {
        return "Remove matching annotations wherever they occur.";
    }

    public RemoveAnnotationVisitor getVisitor() {
        return new RemoveAnnotationVisitor(new AnnotationMatcher(this.annotationPattern));
    }

    public RemoveAnnotation(String annotationPattern) {
        this.annotationPattern = annotationPattern;
    }

    public String getAnnotationPattern() {
        return this.annotationPattern;
    }

    @NonNull
    public String toString() {
        return "RemoveAnnotation(annotationPattern=" + this.getAnnotationPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAnnotation)) {
            return false;
        }
        RemoveAnnotation other = (RemoveAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$annotationPattern = this.getAnnotationPattern();
        String other$annotationPattern = other.getAnnotationPattern();
        return !(this$annotationPattern == null ? other$annotationPattern != null : !this$annotationPattern.equals(other$annotationPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $annotationPattern = this.getAnnotationPattern();
        result = result * 59 + ($annotationPattern == null ? 43 : $annotationPattern.hashCode());
        return result;
    }
}

