/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.GeneralFormatStyle;

public class NormalizeLineBreaks
extends Recipe {
    public String getDisplayName() {
        return "Normalize line breaks";
    }

    public String getDescription() {
        return "Consistently use either Windows style (CRLF) or Linux style (LF) line breaks. If no `GeneralFormatStyle` is specified this will use whichever style of line endings are more common.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new LineBreaksFromCompilationUnitStyle();
    }

    private static class LineBreaksFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private LineBreaksFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                GeneralFormatStyle generalFormatStyle = (GeneralFormatStyle)cu.getStyle(GeneralFormatStyle.class);
                if (generalFormatStyle == null) {
                    generalFormatStyle = AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu);
                }
                this.doAfterVisit(new NormalizeLineBreaksVisitor(generalFormatStyle));
            }
            return (J)tree;
        }
    }
}

