/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;

public class ShiftFormat {
    private ShiftFormat() {
    }

    public static <J2 extends J> J2 indent(J j, Cursor cursor, final int shift) {
        JavaSourceFile cu = (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        final TabsAndIndentsStyle tabsAndIndents = Optional.ofNullable((TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents());
        return (J2)Objects.requireNonNull((J)new JavaIsoVisitor<Integer>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                return space.withWhitespace(this.shift(space.getWhitespace(), shift)).withComments(ListUtils.map(space.getComments(), comment -> comment.withSuffix(this.shift(comment.getSuffix(), shift))));
            }

            private String shift(String whitespace, int shift2) {
                if (!whitespace.contains("\n")) {
                    return whitespace;
                }
                return shift2 < 0 ? ShiftFormat.shiftLeft(tabsAndIndents, whitespace, -1 * shift2) : ShiftFormat.shiftRight(tabsAndIndents, whitespace, shift2);
            }
        }.visit(j, 0));
    }

    static String shiftLeft(TabsAndIndentsStyle tabsAndIndents, String whitespace, int shift) {
        char[] chars = whitespace.toCharArray();
        int erase = 0;
        int shifted = shift * (tabsAndIndents.getUseTabCharacter() != false ? tabsAndIndents.getTabSize() : tabsAndIndents.getIndentSize());
        block4: for (int i = chars.length - 1; i >= 0 && shifted > 0; --i) {
            switch (chars[i]) {
                case '\n': 
                case '\r': {
                    break block4;
                }
                case '\t': {
                    ++erase;
                    shifted -= tabsAndIndents.getTabSize().intValue();
                    continue block4;
                }
                default: {
                    if (!Character.isWhitespace(chars[i])) continue block4;
                    ++erase;
                    --shifted;
                }
            }
        }
        String w = whitespace.substring(0, whitespace.length() - erase);
        for (int i = shifted; i < 0; ++i) {
            w = w + ' ';
        }
        return w;
    }

    static String shiftRight(TabsAndIndentsStyle tabsAndIndents, String whitespace, int shift) {
        StringBuilder w = new StringBuilder(whitespace);
        for (int i = 0; i < shift; ++i) {
            if (tabsAndIndents.getUseTabCharacter().booleanValue()) {
                w.append('\t');
                continue;
            }
            for (int j = 0; j < tabsAndIndents.getIndentSize(); ++j) {
                w.append(' ');
            }
        }
        return w.toString();
    }
}

