/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.style.Deserializer;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.Serializer;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ImportLayoutStyle
implements JavaStyle {
    private final int classCountToUseStarImport;
    private final int nameCountToUseStarImport;
    private final List<Block> layout;
    private final List<Block> packagesToFold;
    private final List<Block> blocksNoCatchalls;
    private final List<Block> blocksOnlyCatchalls;

    public ImportLayoutStyle(int classCountToUseStarImport, int nameCountToUseStarImport, List<Block> layout, List<Block> packagesToFold) {
        this.classCountToUseStarImport = classCountToUseStarImport;
        this.nameCountToUseStarImport = nameCountToUseStarImport;
        this.layout = layout.isEmpty() ? IntelliJ.importLayout().getLayout() : layout;
        this.packagesToFold = packagesToFold;
        Map<Boolean, List<Block>> blockGroups = layout.stream().collect(Collectors.partitioningBy(block -> block instanceof Block.AllOthers));
        this.blocksNoCatchalls = blockGroups.get(false);
        this.blocksOnlyCatchalls = blockGroups.get(true);
    }

    public List<JRightPadded<J.Import>> addImport(List<JRightPadded<J.Import>> originalImports, J.Import toAdd, @Nullable J.Package pkg, Collection<JavaType.FullyQualified> classpath) {
        JRightPadded<J.Import> anImport2;
        int i2;
        int j;
        JRightPadded<J.Import> paddedToAdd = new JRightPadded<J.Import>(toAdd, Space.EMPTY, Markers.EMPTY);
        if (originalImports.isEmpty()) {
            paddedToAdd = pkg == null ? paddedToAdd : paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(Space.format("\n\n")));
            paddedToAdd = ImportLayoutStyle.isPackageAlwaysFolded(this.packagesToFold, paddedToAdd.getElement()) ? paddedToAdd.withElement(paddedToAdd.getElement().withQualid(paddedToAdd.getElement().getQualid().withName(paddedToAdd.getElement().getQualid().getName().withSimpleName("*")))) : paddedToAdd;
            return Collections.singletonList(paddedToAdd);
        }
        JavaType addedType = paddedToAdd.getElement().getQualid().getType();
        for (JRightPadded<J.Import> originalImport : originalImports) {
            if (addedType == null || !TypeUtils.isOfType(addedType, originalImport.getElement().getQualid().getType())) continue;
            return originalImports;
        }
        List<JRightPadded<J.Import>> ideallyOrdered = new ImportLayoutStyle(Integer.MAX_VALUE, Integer.MAX_VALUE, this.layout, this.packagesToFold).orderImports(ListUtils.concat(originalImports, paddedToAdd), new HashSet<JavaType.FullyQualified>());
        JRightPadded<J.Import> before = null;
        JRightPadded<J.Import> after = null;
        Block addToBlock = this.block(paddedToAdd);
        int insertPosition = 0;
        block1: for (int i3 = 0; i3 < ideallyOrdered.size(); ++i3) {
            JRightPadded<J.Import> anImport3 = ideallyOrdered.get(i3);
            if (!anImport3.getElement().isScope(paddedToAdd.getElement())) continue;
            before = i3 > 0 ? ideallyOrdered.get(i3 - 1) : null;
            JRightPadded<J.Import> jRightPadded = after = i3 + 1 < ideallyOrdered.size() ? ideallyOrdered.get(i3 + 1) : null;
            if (before != null) {
                for (j = 0; j < originalImports.size(); ++j) {
                    if (after != null && after.getElement().equals(originalImports.get(j).getElement()) && addToBlock.accept(after)) {
                        insertPosition = j;
                        break block1;
                    }
                    if (!before.getElement().equals(originalImports.get(j).getElement())) continue;
                    insertPosition = j + 1;
                    after = insertPosition < originalImports.size() ? originalImports.get(insertPosition) : null;
                    break block1;
                }
            } else {
                if (after == null) break;
                for (j = 0; j < originalImports.size(); ++j) {
                    if (!after.getElement().equals(originalImports.get(j).getElement())) continue;
                    insertPosition = j;
                    before = j > 0 ? originalImports.get(insertPosition - 1) : null;
                    break block1;
                }
            }
            break;
        }
        AtomicBoolean isNewBlock = new AtomicBoolean(false);
        if (insertPosition != 0 || pkg != null) {
            if (before == null) {
                if (pkg != null) {
                    Space prefix = originalImports.get(0).getElement().getPrefix();
                    paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(prefix));
                }
            } else if (this.block(before) != addToBlock) {
                boolean isFound = false;
                for (j = insertPosition; j < originalImports.size(); ++j) {
                    if (this.block(originalImports.get(j)) != addToBlock) continue;
                    insertPosition = j;
                    after = originalImports.get(j);
                    isFound = true;
                    break;
                }
                isNewBlock.set(!isFound);
                paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(Space.format("\n\n")));
            } else {
                paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(Space.format("\n")));
            }
        }
        ArrayList<JRightPadded<J.Import>> checkConflicts = new ArrayList<JRightPadded<J.Import>>(originalImports);
        checkConflicts.add(paddedToAdd);
        boolean isFoldable = new ImportLayoutConflictDetection(classpath, checkConflicts).isPackageFoldable(ImportLayoutStyle.packageOrOuterClassName(paddedToAdd));
        AtomicInteger starFoldFrom = new AtomicInteger(insertPosition);
        AtomicInteger starFoldTo = new AtomicInteger(insertPosition);
        AtomicBoolean starFold = new AtomicBoolean(false);
        int sameCount = 1;
        for (i2 = insertPosition; i2 < originalImports.size() && this.block(anImport2 = originalImports.get(i2)) == addToBlock && ImportLayoutStyle.packageOrOuterClassName(anImport2).equals(ImportLayoutStyle.packageOrOuterClassName(paddedToAdd)); ++i2) {
            starFoldTo.set(i2 + 1);
            ++sameCount;
        }
        for (i2 = insertPosition - 1; i2 >= 0 && this.block(anImport2 = originalImports.get(i2)) == addToBlock && ImportLayoutStyle.packageOrOuterClassName(anImport2).equals(ImportLayoutStyle.packageOrOuterClassName(paddedToAdd)); --i2) {
            starFoldFrom.set(i2);
            ++sameCount;
        }
        if (isFoldable && (paddedToAdd.getElement().isStatic() && this.nameCountToUseStarImport <= sameCount || !paddedToAdd.getElement().isStatic() && this.classCountToUseStarImport <= sameCount || ImportLayoutStyle.isPackageAlwaysFolded(this.packagesToFold, paddedToAdd.getElement()))) {
            starFold.set(true);
            if (insertPosition != starFoldFrom.get()) {
                paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withPrefix(originalImports.get(starFoldFrom.get()).getElement().getPrefix()));
            }
        }
        if (starFold.get()) {
            paddedToAdd = paddedToAdd.withElement(paddedToAdd.getElement().withQualid(paddedToAdd.getElement().getQualid().withName(paddedToAdd.getElement().getQualid().getName().withSimpleName("*"))));
            JRightPadded<J.Import> jRightPadded = after = starFoldTo.get() < originalImports.size() ? originalImports.get(starFoldTo.get()) : null;
        }
        if (after != null) {
            if (this.block(after) == addToBlock) {
                after = after.withElement(after.getElement().withPrefix(Space.format("\n")));
            } else if (!isNewBlock.get() && after.getElement().getPrefix().getLastWhitespace().chars().filter(c -> c == 10).count() < 2L) {
                after = after.withElement(after.getElement().withPrefix(Space.format("\n\n")));
            }
        }
        JRightPadded<J.Import> finalToAdd = paddedToAdd;
        JRightPadded<J.Import> finalAfter = after;
        return ListUtils.flatMap(originalImports, (i, anImport) -> {
            if (starFold.get() && i >= starFoldFrom.get() && i < starFoldTo.get()) {
                return i.intValue() == starFoldFrom.get() ? finalToAdd : null;
            }
            if (finalAfter != null && ((J.Import)anImport.getElement()).isScope((Tree)finalAfter.getElement())) {
                if (starFold.get()) {
                    if (starFoldFrom.get() == starFoldTo.get()) {
                        return Arrays.asList(finalToAdd, finalAfter);
                    }
                    return finalAfter;
                }
                if (isNewBlock.get()) {
                    return ((J.Import)anImport.getElement()).isStatic() && !((J.Import)finalToAdd.getElement()).isStatic() ? Arrays.asList(finalToAdd, finalAfter) : Arrays.asList(finalAfter, finalToAdd);
                }
                return Arrays.asList(finalToAdd, finalAfter);
            }
            if (i == originalImports.size() - 1 && finalAfter == null) {
                return Arrays.asList(anImport, finalToAdd);
            }
            return anImport;
        });
    }

    private Block block(JRightPadded<J.Import> anImport) {
        for (Block block : this.layout) {
            if (!block.accept(anImport)) continue;
            return block;
        }
        throw new IllegalStateException("Expected to find a block to fit import into.");
    }

    public List<JRightPadded<J.Import>> orderImports(List<JRightPadded<J.Import>> originalImports, Collection<JavaType.FullyQualified> classpath) {
        LayoutState layoutState = new LayoutState();
        ImportLayoutConflictDetection importLayoutConflictDetection = new ImportLayoutConflictDetection(classpath, originalImports);
        ArrayList<JRightPadded<J.Import>> orderedImports = new ArrayList<JRightPadded<J.Import>>();
        block0: for (JRightPadded<J.Import> anImport : originalImports) {
            for (Block block : this.blocksNoCatchalls) {
                if (!block.accept(anImport)) continue;
                layoutState.claimImport(block, anImport);
                continue block0;
            }
            for (Block block : this.blocksOnlyCatchalls) {
                if (!block.accept(anImport)) continue;
                layoutState.claimImport(block, anImport);
                continue block0;
            }
        }
        int importIndex = 0;
        int extraLineSpaceCount = 0;
        String prevWhitespace = "";
        for (Block block : this.layout) {
            if (block instanceof Block.BlankLines) {
                extraLineSpaceCount = 0;
                for (int i = 0; i < ((Block.BlankLines)block).getCount(); ++i) {
                    ++extraLineSpaceCount;
                }
                continue;
            }
            List<JRightPadded<J.Import>> blockOrdering = block.orderedImports(layoutState, this.classCountToUseStarImport, this.nameCountToUseStarImport, importLayoutConflictDetection, this.packagesToFold);
            for (JRightPadded<J.Import> orderedImport : blockOrdering) {
                Space prefix;
                boolean whitespaceContainsCRLF = orderedImport.getElement().getPrefix().getWhitespace().contains("\r\n");
                if (importIndex == 0) {
                    prefix = originalImports.get(0).getElement().getPrefix();
                } else {
                    String newLineCharacters = whitespaceContainsCRLF || StringUtils.isNullOrEmpty((String)orderedImport.getElement().getPrefix().getWhitespace()) && "\r\n".equals(prevWhitespace) ? "\r\n" : "\n";
                    StringBuilder newWhitespace = new StringBuilder(newLineCharacters);
                    for (int i = 0; i < extraLineSpaceCount; ++i) {
                        newWhitespace.append(newLineCharacters);
                    }
                    prefix = orderedImport.getElement().getPrefix().withWhitespace(newWhitespace.toString());
                }
                if (!orderedImport.getElement().getPrefix().equals(prefix)) {
                    orderedImports.add(orderedImport.withElement(orderedImport.getElement().withPrefix(prefix)));
                } else {
                    orderedImports.add(orderedImport);
                }
                prevWhitespace = whitespaceContainsCRLF ? "\r\n" : "\n";
                extraLineSpaceCount = 0;
                ++importIndex;
            }
        }
        return orderedImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean isPackageAlwaysFolded(List<Block> packagesToFold, J.Import checkImport) {
        boolean isPackageFolded = false;
        String anImportName = checkImport.getQualid().printTrimmed(new JavaPrinter());
        for (Block block : packagesToFold) {
            Block.ImportPackage importPackage = (Block.ImportPackage)block;
            if (checkImport.isStatic() != importPackage.isStatic() || !importPackage.packageWildcard.matcher(anImportName).matches()) continue;
            isPackageFolded = true;
        }
        return isPackageFolded;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("classWildcards=").append(this.classCountToUseStarImport).append(", staticWildcards=").append(this.nameCountToUseStarImport).append('\n');
        for (Block block : this.layout) {
            s.append(block).append("\n");
        }
        return s.toString();
    }

    private static String packageOrOuterClassName(JRightPadded<J.Import> anImport) {
        String typeName = anImport.getElement().getTypeName();
        if (anImport.getElement().isStatic()) {
            return typeName;
        }
        String className = anImport.getElement().getClassName();
        if (className.contains("$")) {
            return anImport.getElement().getPackageName() + "." + className.substring(0, className.lastIndexOf(36)).replace('$', '.');
        }
        return anImport.getElement().getPackageName();
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportLayoutStyle)) {
            return false;
        }
        ImportLayoutStyle other = (ImportLayoutStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getClassCountToUseStarImport() != other.getClassCountToUseStarImport()) {
            return false;
        }
        if (this.getNameCountToUseStarImport() != other.getNameCountToUseStarImport()) {
            return false;
        }
        List<Block> this$layout = this.getLayout();
        List<Block> other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout)) {
            return false;
        }
        List<Block> this$packagesToFold = this.getPackagesToFold();
        List<Block> other$packagesToFold = other.getPackagesToFold();
        return !(this$packagesToFold == null ? other$packagesToFold != null : !((Object)this$packagesToFold).equals(other$packagesToFold));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ImportLayoutStyle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getClassCountToUseStarImport();
        result = result * 59 + this.getNameCountToUseStarImport();
        List<Block> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        List<Block> $packagesToFold = this.getPackagesToFold();
        result = result * 59 + ($packagesToFold == null ? 43 : ((Object)$packagesToFold).hashCode());
        return result;
    }

    @Generated
    public int getClassCountToUseStarImport() {
        return this.classCountToUseStarImport;
    }

    @Generated
    public int getNameCountToUseStarImport() {
        return this.nameCountToUseStarImport;
    }

    @Generated
    public List<Block> getLayout() {
        return this.layout;
    }

    @Generated
    public List<Block> getPackagesToFold() {
        return this.packagesToFold;
    }

    @Generated
    public List<Block> getBlocksNoCatchalls() {
        return this.blocksNoCatchalls;
    }

    @Generated
    public List<Block> getBlocksOnlyCatchalls() {
        return this.blocksOnlyCatchalls;
    }

    public static interface Block {
        public boolean accept(JRightPadded<J.Import> var1);

        public List<JRightPadded<J.Import>> orderedImports(LayoutState var1, int var2, int var3, ImportLayoutConflictDetection var4, List<Block> var5);

        public static class AllOthers
        extends ImportPackage {
            private final boolean statik;
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllOthers(boolean statik) {
                super(statik, "*", true);
                this.statik = statik;
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean isStatic() {
                return this.statik;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(anImport)) continue;
                    return false;
                }
                return anImport.getElement().isStatic() == this.statik;
            }

            @Override
            public String toString() {
                return "import " + (this.statik ? "static " : "") + "all other imports";
            }
        }

        public static class ImportPackage
        implements Block {
            static final Comparator<JRightPadded<J.Import>> IMPORT_SORTING = (i1, i2) -> {
                String[] import1 = ((J.Import)i1.getElement()).getQualid().printTrimmed().split("\\.");
                String[] import2 = ((J.Import)i2.getElement()).getQualid().printTrimmed().split("\\.");
                for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                    int diff = import1[i].compareTo(import2[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                if (import1.length == import2.length) {
                    return 0;
                }
                return import1.length > import2.length ? 1 : -1;
            };
            private final Boolean statik;
            private final Pattern packageWildcard;

            public ImportPackage(Boolean statik, String packageWildcard, boolean withSubpackages) {
                this.statik = statik;
                this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
            }

            public boolean isStatic() {
                return this.statik;
            }

            public Pattern getPackageWildcard() {
                return this.packageWildcard;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return anImport.getElement().isStatic() == this.statik.booleanValue() && this.packageWildcard.matcher(anImport.getElement().getQualid().printTrimmed()).matches();
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStarImport, ImportLayoutConflictDetection importLayoutConflictDetection, List<Block> packagesToFold) {
                List<JRightPadded<J.Import>> imports = layoutState.getImports(this);
                Map groupedImports = imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(x$0 -> ImportLayoutStyle.packageOrOuterClassName(x$0), LinkedHashMap::new, Collectors.toList()));
                ArrayList<JRightPadded<J.Import>> ordered = new ArrayList<JRightPadded<J.Import>>(imports.size());
                for (List importGroup : groupedImports.values()) {
                    JRightPadded toStar = (JRightPadded)importGroup.get(0);
                    int threshold = ((J.Import)toStar.getElement()).isStatic() ? nameCountToUseStarImport : classCountToUseStarImport;
                    boolean starImportExists = importGroup.stream().anyMatch(it -> ((J.Import)it.getElement()).getQualid().getSimpleName().equals("*"));
                    if (importLayoutConflictDetection.isPackageFoldable(ImportLayoutStyle.packageOrOuterClassName(toStar)) && (ImportLayoutStyle.isPackageAlwaysFolded(packagesToFold, (J.Import)toStar.getElement()) || importGroup.size() >= threshold || starImportExists && importGroup.size() > 1)) {
                        J.FieldAccess qualid = ((J.Import)toStar.getElement()).getQualid();
                        J.Identifier name = qualid.getName();
                        Set typeNamesInThisGroup = importGroup.stream().map(im -> ((J.Import)im.getElement()).getClassName()).collect(Collectors.toSet());
                        Optional<String> oneOfTheTypesIsInAnotherGroupToo = groupedImports.values().stream().filter(group -> group != importGroup).flatMap(group -> group.stream().filter(im -> typeNamesInThisGroup.contains(((J.Import)im.getElement()).getClassName()))).map(im -> ((J.Import)im.getElement()).getTypeName()).findAny();
                        if (starImportExists || !oneOfTheTypesIsInAnotherGroupToo.isPresent()) {
                            ordered.add(toStar.withElement(((J.Import)toStar.getElement()).withQualid(qualid.withName(name.withSimpleName("*")))));
                            continue;
                        }
                    }
                    Predicate predicate = StreamUtils.distinctBy(t -> ((J.Import)t.getElement()).printTrimmed(new JavaPrinter()));
                    for (JRightPadded importJRightPadded : importGroup) {
                        if (!predicate.test(importJRightPadded)) continue;
                        ordered.add(importJRightPadded);
                    }
                }
                ordered.sort(IMPORT_SORTING);
                return ordered;
            }

            public String toString() {
                return "import " + (this.statik != false ? "static " : "") + this.packageWildcard;
            }
        }

        public static class BlankLines
        implements Block {
            private int count = 1;

            private int getCount() {
                return this.count;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports(LayoutState layoutState, int classCountToUseStarImport, int nameCountToUseStartImport, ImportLayoutConflictDetection importLayoutConflictDetection, List<Block> packagesToFold) {
                return Collections.emptyList();
            }

            public String toString() {
                return "<blank line>" + (this.count > 1 ? " (x" + this.count + ")" : "");
            }
        }
    }

    private static class ImportLayoutConflictDetection {
        private final Collection<JavaType.FullyQualified> classpath;
        private final List<JRightPadded<J.Import>> originalImports;
        private final Set<String> jvmClasspathNames = new HashSet<String>();
        private @Nullable Set<String> containsClassNameConflict = null;

        ImportLayoutConflictDetection(Collection<JavaType.FullyQualified> classpath, List<JRightPadded<J.Import>> originalImports) {
            this.classpath = classpath;
            this.originalImports = originalImports;
        }

        public boolean isPackageFoldable(String packageName) {
            if (this.containsClassNameConflict == null) {
                this.containsClassNameConflict = new HashSet<String>();
                this.setJVMClassNames();
                Map<String, Set<String>> nameToPackages = this.mapNamesInPackageToPackages();
                for (String className : nameToPackages.keySet()) {
                    if (nameToPackages.get(className).size() <= 1 && !this.jvmClasspathNames.contains(className)) continue;
                    this.containsClassNameConflict.addAll((Collection<String>)nameToPackages.get(className));
                }
            }
            return this.classpath.isEmpty() || !this.containsClassNameConflict.contains(packageName);
        }

        private void setJVMClassNames() {
            for (JavaType.FullyQualified fqn : this.classpath) {
                if (!fqn.getFullyQualifiedName().startsWith("java.lang.") || !"java.lang".equals(fqn.getPackageName())) continue;
                this.jvmClasspathNames.add(fqn.getClassName());
            }
        }

        private Map<String, Set<String>> mapNamesInPackageToPackages() {
            HashMap<String, Set<String>> nameToPackages = new HashMap<String, Set<String>>();
            HashSet<String> checkPackageForClasses = new HashSet<String>();
            for (JRightPadded<J.Import> anImport : this.originalImports) {
                checkPackageForClasses.add(ImportLayoutStyle.packageOrOuterClassName(anImport));
                nameToPackages.computeIfAbsent(anImport.getElement().getClassName(), p -> new HashSet(3)).add(anImport.getElement().getPackageName());
            }
            for (JavaType.FullyQualified classGraphFqn : this.classpath) {
                String packageName = classGraphFqn.getPackageName();
                if (checkPackageForClasses.contains(packageName)) {
                    String className = classGraphFqn.getClassName();
                    nameToPackages.computeIfAbsent(className, p -> new HashSet(3)).add(packageName);
                    continue;
                }
                if (!checkPackageForClasses.contains(classGraphFqn.getFullyQualifiedName())) continue;
                packageName = classGraphFqn.getFullyQualifiedName();
                for (JavaType.Variable member : classGraphFqn.getMembers()) {
                    if (!member.hasFlags(Flag.Static)) continue;
                    nameToPackages.computeIfAbsent(member.getName(), p -> new HashSet(3)).add(packageName);
                }
                for (JavaType.Method method : classGraphFqn.getMethods()) {
                    if (!method.hasFlags(Flag.Static)) continue;
                    nameToPackages.computeIfAbsent(method.getName(), p -> new HashSet(3)).add(packageName);
                }
            }
            return nameToPackages;
        }
    }

    private static class LayoutState {
        Map<Block, List<JRightPadded<J.Import>>> imports = new HashMap<Block, List<JRightPadded<J.Import>>>();

        private LayoutState() {
        }

        public void claimImport(Block block, JRightPadded<J.Import> import_) {
            this.imports.computeIfAbsent(block, b -> new ArrayList()).add(import_);
        }

        public List<JRightPadded<J.Import>> getImports(Block block) {
            return this.imports.getOrDefault(block, Collections.emptyList());
        }
    }

    public static class Builder {
        private final List<Block> blocks = new ArrayList<Block>();
        private final List<Block> packagesToFold = new ArrayList<Block>();
        private int classCountToUseStarImport = 5;
        private int nameCountToUseStarImport = 3;

        public Builder importAllOthers() {
            this.blocks.add(new Block.AllOthers(false));
            return this;
        }

        public Builder importStaticAllOthers() {
            this.blocks.add(new Block.AllOthers(true));
            return this;
        }

        public Builder blankLine() {
            if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
            } else {
                this.blocks.add(new Block.BlankLines());
            }
            return this;
        }

        public Builder importPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(false, packageWildcard, withSubpackages));
            return this;
        }

        public Builder importPackage(String packageWildcard) {
            return this.importPackage(packageWildcard, true);
        }

        public Builder staticImportPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(true, packageWildcard, withSubpackages));
            return this;
        }

        public Builder staticImportPackage(String packageWildcard) {
            return this.staticImportPackage(packageWildcard, true);
        }

        public Builder packageToFold(String packageWildcard, Boolean withSubpackages) {
            this.packagesToFold.add(new Block.ImportPackage(false, packageWildcard, withSubpackages));
            return this;
        }

        public Builder packageToFold(String packageWildcard) {
            return this.packageToFold(packageWildcard, true);
        }

        public Builder staticPackageToFold(String packageWildcard, Boolean withSubpackages) {
            this.packagesToFold.add(new Block.ImportPackage(true, packageWildcard, withSubpackages));
            return this;
        }

        public Builder staticPackageToFold(String packageWildcard) {
            return this.staticPackageToFold(packageWildcard, true);
        }

        public Builder classCountToUseStarImport(int classCountToUseStarImport) {
            this.classCountToUseStarImport = classCountToUseStarImport;
            return this;
        }

        public Builder nameCountToUseStarImport(int nameCountToUseStarImport) {
            this.nameCountToUseStarImport = nameCountToUseStarImport;
            return this;
        }

        public ImportLayoutStyle build() {
            assert (this.blocks.stream().anyMatch(it -> it instanceof Block.AllOthers && ((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all static imports, but no such block was found in the specified layout";
            assert (this.blocks.stream().anyMatch(it -> it instanceof Block.AllOthers && !((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all non-static imports, but no such block was found in the specified layout";
            for (Block block : this.blocks) {
                if (!(block instanceof Block.AllOthers)) continue;
                ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
            }
            return new ImportLayoutStyle(this.classCountToUseStarImport, this.nameCountToUseStarImport, this.blocks, this.packagesToFold);
        }
    }
}

