/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks;

import java.util.Arrays;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.PropertyType;
import org.openrewrite.tools.checkstyle.XdocsPropertyType;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@FileStatefulCheck
public class DescendantTokenCheck
extends AbstractCheck {
    public static final String MSG_KEY_MIN = "descendant.token.min";
    public static final String MSG_KEY_MAX = "descendant.token.max";
    public static final String MSG_KEY_SUM_MIN = "descendant.token.sum.min";
    public static final String MSG_KEY_SUM_MAX = "descendant.token.sum.max";
    private int minimumDepth;
    private int maximumDepth = Integer.MAX_VALUE;
    private int minimumNumber;
    private int maximumNumber = Integer.MAX_VALUE;
    private boolean sumTokenCounts;
    @XdocsPropertyType(value=PropertyType.TOKEN_ARRAY)
    private int[] limitedTokens = CommonUtil.EMPTY_INT_ARRAY;
    private String minimumMessage;
    private String maximumMessage;
    private int[] counts = CommonUtil.EMPTY_INT_ARRAY;

    @Override
    public int[] getAcceptableTokens() {
        return TokenUtil.getAllTokenIds();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        Arrays.fill(this.counts, 0);
        this.countTokens(ast, 0);
        if (this.sumTokenCounts) {
            this.logAsTotal(ast);
        } else {
            this.logAsSeparated(ast);
        }
    }

    private void logAsSeparated(DetailAST ast) {
        String name = TokenUtil.getTokenName(ast.getType());
        for (int element : this.limitedTokens) {
            String descendantName;
            int tokenCount = this.counts[element - 1];
            if (tokenCount < this.minimumNumber) {
                descendantName = TokenUtil.getTokenName(element);
                if (this.minimumMessage == null) {
                    this.minimumMessage = MSG_KEY_MIN;
                }
                this.log(ast, this.minimumMessage, String.valueOf(tokenCount), String.valueOf(this.minimumNumber), name, descendantName);
            }
            if (tokenCount <= this.maximumNumber) continue;
            descendantName = TokenUtil.getTokenName(element);
            if (this.maximumMessage == null) {
                this.maximumMessage = MSG_KEY_MAX;
            }
            this.log(ast, this.maximumMessage, String.valueOf(tokenCount), String.valueOf(this.maximumNumber), name, descendantName);
        }
    }

    private void logAsTotal(DetailAST ast) {
        String name = TokenUtil.getTokenName(ast.getType());
        int total = 0;
        for (int element : this.limitedTokens) {
            total += this.counts[element - 1];
        }
        if (total < this.minimumNumber) {
            if (this.minimumMessage == null) {
                this.minimumMessage = MSG_KEY_SUM_MIN;
            }
            this.log(ast, this.minimumMessage, String.valueOf(total), String.valueOf(this.minimumNumber), name);
        }
        if (total > this.maximumNumber) {
            if (this.maximumMessage == null) {
                this.maximumMessage = MSG_KEY_SUM_MAX;
            }
            this.log(ast, this.maximumMessage, String.valueOf(total), String.valueOf(this.maximumNumber), name);
        }
    }

    private void countTokens(DetailAST ast, int depth) {
        if (depth <= this.maximumDepth) {
            int type;
            if (depth >= this.minimumDepth && (type = ast.getType()) <= this.counts.length) {
                int n = type - 1;
                this.counts[n] = this.counts[n] + 1;
            }
            int nextDepth = depth + 1;
            for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.countTokens(child, nextDepth);
            }
        }
    }

    public void setLimitedTokens(String ... limitedTokensParam) {
        this.limitedTokens = new int[limitedTokensParam.length];
        int maxToken = 0;
        for (int i = 0; i < limitedTokensParam.length; ++i) {
            this.limitedTokens[i] = TokenUtil.getTokenId(limitedTokensParam[i]);
            if (this.limitedTokens[i] < maxToken + 1) continue;
            maxToken = this.limitedTokens[i];
        }
        this.counts = new int[maxToken];
    }

    public void setMinimumDepth(int minimumDepth) {
        this.minimumDepth = minimumDepth;
    }

    public void setMaximumDepth(int maximumDepth) {
        this.maximumDepth = maximumDepth;
    }

    public void setMinimumNumber(int minimumNumber) {
        this.minimumNumber = minimumNumber;
    }

    public void setMaximumNumber(int maximumNumber) {
        this.maximumNumber = maximumNumber;
    }

    public void setMinimumMessage(String message) {
        this.minimumMessage = message;
    }

    public void setMaximumMessage(String message) {
        this.maximumMessage = message;
    }

    public void setSumTokenCounts(boolean sum) {
        this.sumTokenCounts = sum;
    }
}

