/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class ExecutionContextParameterName
extends Recipe {
    public String getDisplayName() {
        return "Use a standard name for `ExecutionContext`";
    }

    public String getDescription() {
        return "Visitors that are parameterized with `ExecutionContext` should use the parameter name `ctx`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType("org.openrewrite.Recipe", false), new UsesType("org.openrewrite.Visitor", false)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                for (Statement parameter : ((J.MethodDeclaration)m).getParameters()) {
                    J.VariableDeclarations param;
                    if (!(parameter instanceof J.VariableDeclarations) || !TypeUtils.isOfClassType((param = (J.VariableDeclarations)parameter).getType(), "org.openrewrite.ExecutionContext")) continue;
                    m = (J.MethodDeclaration)new RenameVariable(param.getVariables().get(0), "ctx").visitNonNull(m, ctx);
                }
                return m;
            }
        });
    }
}

