/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.format.NormalizeLineBreaksVisitor;
import org.openrewrite.json.format.TabsAndIndentsVisitor;
import org.openrewrite.json.style.Autodetect;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;

public class AutoFormatVisitor<P>
extends JsonIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public Json preVisit(Json tree, P p) {
        this.stopAfterPreVisit();
        Json.Document doc = (Json.Document)this.getCursor().firstEnclosingOrThrow(Json.Document.class);
        Cursor cursor = this.getCursor().getParentOrThrow();
        Autodetect autodetectedStyle = Autodetect.detector().sample(doc).build();
        Json js = tree;
        js = (Json)new TabsAndIndentsVisitor((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)doc, () -> (TabsAndIndentsStyle)autodetectedStyle.getStyle(TabsAndIndentsStyle.class)), this.stopAfter).visitNonNull(js, p, cursor.fork());
        js = (Json)new NormalizeLineBreaksVisitor((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)doc, () -> (GeneralFormatStyle)autodetectedStyle.getStyle(GeneralFormatStyle.class)), this.stopAfter).visitNonNull(js, p, cursor.fork());
        return js;
    }

    @Override
    public Json.Document visitDocument(Json.Document js, P p) {
        Autodetect autodetectedStyle = Autodetect.detector().sample(js).build();
        js = (Json.Document)new TabsAndIndentsVisitor((TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)js, () -> (TabsAndIndentsStyle)autodetectedStyle.getStyle(TabsAndIndentsStyle.class)), this.stopAfter).visitNonNull(js, p);
        js = (Json.Document)new NormalizeLineBreaksVisitor((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)js, () -> (GeneralFormatStyle)autodetectedStyle.getStyle(GeneralFormatStyle.class)), this.stopAfter).visitNonNull(js, p);
        return js;
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        return (Json)super.visit(tree, p);
    }
}

