/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KContainer;
import org.openrewrite.kotlin.tree.KLeftPadded;
import org.openrewrite.kotlin.tree.KRightPadded;
import org.openrewrite.kotlin.tree.KSpace;

public class KotlinVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof K.CompilationUnit;
    }

    public String getLanguage() {
        return "kotlin";
    }

    public J visitCompilationUnit(K.CompilationUnit cu, P p) {
        K.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        if ((c = c.withAnnotations(ListUtils.map(c.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)))).getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration((JRightPadded<J.Package>)this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, p));
        }
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Kotlin has a different structure for its compilation unit. See K.CompilationUnit.");
    }

    public J visitBinary(K.Binary binary, P p) {
        K.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), KSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof K.Binary)) {
            return temp;
        }
        b = (K.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), KLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitFunctionType(K.FunctionType functionType, P p) {
        K.FunctionType f = functionType;
        f = f.withReceiver(this.visitRightPadded(f.getReceiver(), KRightPadded.Location.FUNCTION_TYPE_RECEIVER, p));
        f = f.withTypedTree((TypedTree)this.visitAndCast((Tree)f.getTypedTree(), p));
        return f;
    }

    public J visitKReturn(K.KReturn kReturn, P p) {
        K.KReturn r = kReturn;
        r = (K.KReturn)r.withPrefix(this.visitSpace(r.getPrefix(), KSpace.Location.KRETURN_PREFIX, p));
        r = (K.KReturn)r.withMarkers(this.visitMarkers(r.getMarkers(), p));
        r = r.withExpression((J.Return)this.visitAndCast((Tree)r.getExpression(), p));
        r = r.withLabel((J.Identifier)this.visitAndCast((Tree)r.getLabel(), p));
        return r;
    }

    public J visitKString(K.KString kString, P p) {
        K.KString k = kString;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.KSTRING_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.KString)) {
            return temp;
        }
        k = (K.KString)temp;
        k = k.withStrings(ListUtils.map(k.getStrings(), s -> (J)this.visit((Tree)s, p)));
        k = k.withType(this.visitType(k.getType(), p));
        return k;
    }

    public J visitKStringValue(K.KString.Value value, P p) {
        K.KString.Value v = value;
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withTree((J)this.visit((Tree)v.getTree(), p));
        return v;
    }

    public J visitListLiteral(K.ListLiteral listLiteral, P p) {
        K.ListLiteral l = listLiteral;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), KSpace.Location.LIST_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof K.ListLiteral)) {
            return temp;
        }
        l = (K.ListLiteral)temp;
        l = l.getPadding().withElements(this.visitContainer(l.getPadding().getElements(), KContainer.Location.LIST_LITERAL_ELEMENTS, p));
        l = l.withType(this.visitType(l.getType(), p));
        return l;
    }

    public J visitNamedVariableInitializer(K.NamedVariableInitializer namedVariableInitializer, P p) {
        K.NamedVariableInitializer n = namedVariableInitializer;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), KSpace.Location.NAMED_VARIABLE_INITIALIZER_PREFIX, p));
        n = n.withMarkers(this.visitMarkers(n.getMarkers(), p));
        n = n.withInitializations(ListUtils.map(n.getInitializations(), it -> (J)this.visitAndCast((Tree)it, p)));
        return n;
    }

    public J visitWhen(K.When when, P p) {
        K.When w = when;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.When)) {
            return temp;
        }
        w = (K.When)temp;
        w = w.withSelector((J.ControlParentheses<Expression>)((J.ControlParentheses)this.visitAndCast((Tree)w.getSelector(), p)));
        w = w.withBranches((J.Block)this.visitAndCast((Tree)w.getBranches(), p));
        w = w.withType(this.visitType(w.getType(), p));
        return w;
    }

    public J visitWhenBranch(K.WhenBranch whenBranch, P p) {
        K.WhenBranch w = whenBranch;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_BRANCH_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.WhenBranch)) {
            return temp;
        }
        w = (K.WhenBranch)temp;
        w = w.getPadding().withExpressions(this.visitContainer(w.getPadding().getExpressions(), KContainer.Location.WHEN_BRANCH_EXPRESSION, p));
        w = w.getPadding().withBody((JRightPadded<J>)this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.CASE_BODY, p));
        return w;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, KRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, KLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, KSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, KContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }
}

