/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.kotlin.KotlinTemplate;
import org.openrewrite.kotlin.KotlinVisitor;

public final class ReplaceCharToIntWithCode
extends Recipe {
    private static final MethodMatcher CHAR_TO_INT_METHOD_MATCHER = new MethodMatcher("kotlin.Char toInt()");

    public String getDisplayName() {
        return "Replace `Char#toInt()` with `Char#code`";
    }

    public String getDescription() {
        return "Replace the usage of the deprecated `Char#toInt()` with `Char#code`. Please ensure that your Kotlin version is 1.5 or later to support the `Char#code` property. Note that the current implementation does not perform a Kotlin version check.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (CHAR_TO_INT_METHOD_MATCHER.matches((MethodCall)method) && method.getSelect() != null) {
                    return KotlinTemplate.builder("#{any(Char)}.code").build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getSelect()}).withPrefix(method.getPrefix());
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    public String toString() {
        return "ReplaceCharToIntWithCode()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceCharToIntWithCode)) {
            return false;
        }
        ReplaceCharToIntWithCode other = (ReplaceCharToIntWithCode)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplaceCharToIntWithCode;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

