/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.marker.PrimaryConstructor;

public class NormalizeFormatVisitor<P>
extends KotlinIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    @JsonCreator
    public NormalizeFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public NormalizeFormatVisitor() {
        this(null);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        if (!c.getLeadingAnnotations().isEmpty()) {
            c = this.concatenatePrefix(c, Space.firstPrefix((List)c.getLeadingAnnotations()));
            c = c.withLeadingAnnotations(Space.formatFirstPrefix((List)c.getLeadingAnnotations(), (Space)Space.EMPTY));
            return c;
        }
        if (!c.getModifiers().isEmpty()) {
            c = this.concatenatePrefix(c, Space.firstPrefix((List)c.getModifiers()));
            c = c.withModifiers(Space.formatFirstPrefix((List)c.getModifiers(), (Space)Space.EMPTY));
            return c;
        }
        if (!c.getPadding().getKind().getPrefix().isEmpty()) {
            c = this.concatenatePrefix(c, c.getPadding().getKind().getPrefix());
            c = c.getPadding().withKind(c.getPadding().getKind().withPrefix(Space.EMPTY));
            return c;
        }
        JContainer typeParameters = c.getPadding().getTypeParameters();
        if (typeParameters != null && !typeParameters.getElements().isEmpty()) {
            c = this.concatenatePrefix(c, typeParameters.getBefore());
            c = c.getPadding().withTypeParameters(typeParameters.withBefore(Space.EMPTY));
            return c;
        }
        return c.withName(c.getName().withPrefix(c.getName().getPrefix().withWhitespace(" ")));
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        if (m.getMarkers().findFirst(PrimaryConstructor.class).isPresent()) {
            return m;
        }
        if (!m.getLeadingAnnotations().isEmpty()) {
            m = this.concatenatePrefix(m, Space.firstPrefix((List)m.getLeadingAnnotations()));
            m = m.withLeadingAnnotations(Space.formatFirstPrefix((List)m.getLeadingAnnotations(), (Space)Space.EMPTY));
            return m;
        }
        if (!m.getModifiers().isEmpty()) {
            m = this.concatenatePrefix(m, Space.firstPrefix((List)m.getModifiers()));
            m = m.withModifiers(Space.formatFirstPrefix((List)m.getModifiers(), (Space)Space.EMPTY));
            return m;
        }
        if (m.getAnnotations().getTypeParameters() != null) {
            if (!m.getAnnotations().getTypeParameters().getTypeParameters().isEmpty()) {
                m = this.concatenatePrefix(m, m.getAnnotations().getTypeParameters().getPrefix());
                m = m.getAnnotations().withTypeParameters(m.getAnnotations().getTypeParameters().withPrefix(Space.EMPTY));
            }
            return m;
        }
        if (m.getReturnTypeExpression() != null) {
            if (!m.getReturnTypeExpression().getPrefix().getWhitespace().isEmpty()) {
                m = this.concatenatePrefix(m, m.getReturnTypeExpression().getPrefix());
                m = m.withReturnTypeExpression((TypeTree)m.getReturnTypeExpression().withPrefix(Space.EMPTY));
            }
            return m;
        }
        m = this.concatenatePrefix(m, m.getName().getPrefix());
        m = m.withName(m.getName().withPrefix(Space.EMPTY));
        return m;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, p);
        if (!v.getLeadingAnnotations().isEmpty()) {
            v = this.concatenatePrefix(v, Space.firstPrefix((List)v.getLeadingAnnotations()));
            v = v.withLeadingAnnotations(Space.formatFirstPrefix((List)v.getLeadingAnnotations(), (Space)Space.EMPTY));
            return v;
        }
        if (!v.getModifiers().isEmpty()) {
            v = this.concatenatePrefix(v, Space.firstPrefix((List)v.getModifiers()));
            v = v.withModifiers(Space.formatFirstPrefix((List)v.getModifiers(), (Space)Space.EMPTY));
            return v;
        }
        return v;
    }

    private <J2 extends J> J2 concatenatePrefix(J2 j, Space prefix) {
        final String shift = StringUtils.commonMargin(null, (CharSequence)j.getPrefix().getWhitespace());
        List comments = ListUtils.concatAll((List)j.getComments(), (List)ListUtils.map((List)prefix.getComments(), comment -> {
            Comment c = comment;
            if (shift.isEmpty()) {
                return c;
            }
            if (comment instanceof TextComment) {
                TextComment textComment = (TextComment)c;
                c = textComment.withText(textComment.getText().replace("\n", "\n" + shift));
            } else if (c instanceof Javadoc) {
                c = (Comment)new JavadocVisitor<Integer>(new JavaVisitor()){

                    public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, Integer integer) {
                        return lineBreak.withMargin(shift + lineBreak.getMargin());
                    }
                }.visitNonNull((Tree)((Javadoc)c), (Object)0);
            }
            if (c.getSuffix().contains("\n")) {
                c = c.withSuffix(c.getSuffix().replace("\n", "\n" + shift));
            }
            return c;
        }));
        return (J2)j.withPrefix(j.getPrefix().withWhitespace(j.getPrefix().getWhitespace() + prefix.getWhitespace()).withComments(comments));
    }

    public @Nullable J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    public @Nullable J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

