/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface ManagedDependency {
    public String getGroupId();

    public String getArtifactId();

    @Nullable
    public String getVersion();

    public <D extends ManagedDependency> D withVersion(String var1);

    public static final class Imported
    implements ManagedDependency {
        private final GroupArtifactVersion gav;

        @Override
        public String getGroupId() {
            return Objects.requireNonNull(this.gav.getGroupId());
        }

        @Override
        public String getArtifactId() {
            return this.gav.getArtifactId();
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.gav.getVersion();
        }

        public Imported withVersion(String version) {
            return this.withGav(this.gav.withVersion(version));
        }

        @Generated
        public Imported(GroupArtifactVersion gav) {
            this.gav = gav;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Imported)) {
                return false;
            }
            Imported other = (Imported)o;
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            return !(this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ManagedDependency.Imported(gav=" + this.getGav() + ")";
        }

        @NonNull
        @Generated
        public Imported withGav(GroupArtifactVersion gav) {
            return this.gav == gav ? this : new Imported(gav);
        }
    }

    public static final class Defined
    implements ManagedDependency {
        private final GroupArtifactVersion gav;
        @Nullable
        private final String scope;
        @Nullable
        private final String type;
        @Nullable
        private final String classifier;
        private final List<GroupArtifact> exclusions;

        @Override
        public String getGroupId() {
            return Objects.requireNonNull(this.gav.getGroupId());
        }

        @Override
        public String getArtifactId() {
            return this.gav.getArtifactId();
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.gav.getVersion();
        }

        public Defined withVersion(String version) {
            return this.withGav(this.gav.withVersion(version));
        }

        @Generated
        public Defined(GroupArtifactVersion gav, @Nullable String scope, @Nullable String type, @Nullable String classifier, List<GroupArtifact> exclusions) {
            this.gav = gav;
            this.scope = scope;
            this.type = type;
            this.classifier = classifier;
            this.exclusions = exclusions;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Nullable
        @Generated
        public String getScope() {
            return this.scope;
        }

        @Nullable
        @Generated
        public String getType() {
            return this.type;
        }

        @Nullable
        @Generated
        public String getClassifier() {
            return this.classifier;
        }

        @Generated
        public List<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Defined)) {
                return false;
            }
            Defined other = (Defined)o;
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            List<GroupArtifact> this$exclusions = this.getExclusions();
            List<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            List<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ManagedDependency.Defined(gav=" + this.getGav() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", exclusions=" + this.getExclusions() + ")";
        }

        @NonNull
        @Generated
        public Defined withGav(GroupArtifactVersion gav) {
            return this.gav == gav ? this : new Defined(gav, this.scope, this.type, this.classifier, this.exclusions);
        }

        @NonNull
        @Generated
        public Defined withScope(@Nullable String scope) {
            return this.scope == scope ? this : new Defined(this.gav, scope, this.type, this.classifier, this.exclusions);
        }

        @NonNull
        @Generated
        public Defined withType(@Nullable String type) {
            return this.type == type ? this : new Defined(this.gav, this.scope, type, this.classifier, this.exclusions);
        }

        @NonNull
        @Generated
        public Defined withClassifier(@Nullable String classifier) {
            return this.classifier == classifier ? this : new Defined(this.gav, this.scope, this.type, classifier, this.exclusions);
        }

        @NonNull
        @Generated
        public Defined withExclusions(List<GroupArtifact> exclusions) {
            return this.exclusions == exclusions ? this : new Defined(this.gav, this.scope, this.type, this.classifier, exclusions);
        }
    }
}

