/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.xml.tree.Xml;

public class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        if (MavenSettings.readFromDiskEnabled()) {
            MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
            mctx.setMavenSettings(MavenSettings.readMavenSettingsFromDisk((ExecutionContext)mctx), new String[0]);
        }
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before) {
        return Assertions.pomXml(before, (SourceSpec<Xml.Document> s) -> {});
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, Assertions::pomResolvedSuccessfully, Assertions::customizeExecutionContext);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, @Language(value="xml") @Nullable String after) {
        return Assertions.pomXml(before, after, s -> {});
    }

    public static SourceSpecs pomXml(@Language(value="xml") @Nullable String before, @Language(value="xml") @Nullable String after, Consumer<SourceSpec<Xml.Document>> spec) {
        SourceSpec maven = new SourceSpec(Xml.Document.class, "maven", (Parser.Builder)MavenParser.builder(), before, Assertions::pomResolvedSuccessfully, Assertions::customizeExecutionContext).after(s -> after);
        maven.path("pom.xml");
        spec.accept((SourceSpec<Xml.Document>)maven);
        return maven;
    }

    private static SourceFile pomResolvedSuccessfully(SourceFile sourceFile, TypeValidation typeValidation) {
        if (typeValidation.dependencyModel()) {
            sourceFile.getMarkers().findFirst(MavenResolutionResult.class).orElseThrow(() -> new IllegalStateException("No MavenResolutionResult found"));
        }
        return sourceFile;
    }
}

