/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.AddPropertyVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveProperty;
import org.openrewrite.xml.tree.Xml;

public final class AddProperty
extends Recipe {
    @Option(displayName="Key", description="The name of the property key to be added.", example="junit.version")
    private final String key;
    @Option(displayName="Value", description="The value of property to be added.", example="4.13")
    private final String value;
    @Option(displayName="Preserve existing value", description="Preserve previous value if the property already exists in the pom file.", required=false)
    private final @Nullable Boolean preserveExistingValue;
    @Option(displayName="Trust parent POM", description="If the parent defines a property with the same key, trust it even if the value isn't the same. Useful when you want to wait for the parent to have its value changed first. The parent is not trusted by default.", required=false)
    private final @Nullable Boolean trustParent;

    public String getDisplayName() {
        return "Add Maven project property";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s=%s`", this.key, this.value);
    }

    public String getDescription() {
        return "Add a new property to the Maven project property. Prefers to add the property to the parent if the project has multiple modules.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String keyToReplace = this.key.replace("${", "").replace("}", "");
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                String parentValue = this.getResolutionResult().getPom().getRequested().getProperties().get(AddProperty.this.key);
                if (Boolean.TRUE.equals(AddProperty.this.trustParent) && (parentValue == null || AddProperty.this.value.equals(parentValue)) || AddProperty.this.value.equals(this.getResolutionResult().getPom().getProperties().get(AddProperty.this.key))) {
                    return document;
                }
                if (document.getRoot().getChild("parent").flatMap(tag -> tag.getChild("relativePath")).flatMap(Xml.Tag::getValue).flatMap(v -> v.trim().isEmpty() ? Optional.empty() : Optional.of(v)).isPresent()) {
                    if (Boolean.TRUE.equals(AddProperty.this.preserveExistingValue)) {
                        return document;
                    }
                    return (Xml.Document)new RemoveProperty(AddProperty.this.key).getVisitor().visitNonNull((Tree)document, (Object)ctx);
                }
                return (Xml.Document)new AddPropertyVisitor(keyToReplace, AddProperty.this.value, AddProperty.this.preserveExistingValue).visitNonNull((Tree)document, ctx);
            }
        };
    }

    @Generated
    public AddProperty(String key, String value, @Nullable Boolean preserveExistingValue, @Nullable Boolean trustParent) {
        this.key = key;
        this.value = value;
        this.preserveExistingValue = preserveExistingValue;
        this.trustParent = trustParent;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public @Nullable Boolean getPreserveExistingValue() {
        return this.preserveExistingValue;
    }

    @Generated
    public @Nullable Boolean getTrustParent() {
        return this.trustParent;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddProperty(key=" + this.getKey() + ", value=" + this.getValue() + ", preserveExistingValue=" + this.getPreserveExistingValue() + ", trustParent=" + this.getTrustParent() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddProperty)) {
            return false;
        }
        AddProperty other = (AddProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$preserveExistingValue = this.getPreserveExistingValue();
        Boolean other$preserveExistingValue = other.getPreserveExistingValue();
        if (this$preserveExistingValue == null ? other$preserveExistingValue != null : !((Object)this$preserveExistingValue).equals(other$preserveExistingValue)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $preserveExistingValue = this.getPreserveExistingValue();
        result = result * 59 + ($preserveExistingValue == null ? 43 : ((Object)$preserveExistingValue).hashCode());
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

